open Printf
open Ast
module StringMap = Map.Make(String)

let source = "example.dat"
let ir = "IR.txt"
let rmap = StringMap.empty 
let ic = open_in source
let lexbuf = Lexing.from_channel ic
let ((values, triangles), rule_decl, operations) = Parser.program Scanner.token lexbuf 
let oc = open_out ir
let global_value = []



let rec enum stride n = function
	  [] -> []
	| hd::tl -> (n, hd) :: enum stride (n+stride) tl


let string_map_vpairs map pairs = 
	List.fold_left (fun m (i,n) -> fprintf oc "%f\n" n.value ;StringMap.add n.vname i m) map pairs


let string_map_tpairs map pairs = 
	List.fold_left (fun m (i,n) ->

		fprintf oc "%f\n" n.tvertex.avtxx ;
		fprintf oc "%f\n" n.tvertex.avtxy ;
		fprintf oc "%f\n" n.tvertex.bvtxx ;
		fprintf oc "%f\n" n.tvertex.bvtxy ;
		fprintf oc "%f\n" n.tvertex.cvtxx ;
		fprintf oc "%f\n" n.tvertex.cvtxy ;
	   	fprintf oc "%f\n" n.tline.alen ;
		fprintf oc "%f\n" n.tline.blen ;
		fprintf oc "%f\n" n.tline.clen ;
		StringMap.add n.tname i m) map pairs

let string_map_rpairs map pairs = 
	List.fold_left (fun m (i,n) -> StringMap.add n i m) map pairs
let _ =
(*binding two maps for value and triangle*)
let vlist = enum 1 0 values in
let vmap = string_map_vpairs StringMap.empty vlist in 
let tlist = enum 9 (List.length values) triangles in
let tmap = string_map_tpairs StringMap.empty tlist in
(*print rul for starting the rul definition*)
let _ = fprintf oc "rul\n" in



let translate rule offset  = 
	let arg = rule.paras and condition = rule.cond and stmt = rule.body in
	let rule_string_and_length = 
 		let rec load_argument counter = function
		  	[] -> ([], counter)
			| hd::tl -> if hd.ptp =  "value" then let rtn = load_argument (counter+1) tl in ( ([ String.concat " " ["pop"; (string_of_int counter)]]@ (fst rtn)) ,(snd rtn))
								else let rtnt = load_argument (counter+9) tl in 
										(( 
										[String.concat " " ["pop"; string_of_int (counter)];
										String.concat " " ["pop"; string_of_int (counter+1)];
										String.concat " " ["pop"; string_of_int (counter+2)];
										String.concat " " ["pop"; string_of_int (counter+3)];
										String.concat " " ["pop"; string_of_int (counter+4)];
										String.concat " " ["pop"; string_of_int (counter+5)];
										String.concat " " ["pop"; string_of_int (counter+6)];
										String.concat " " ["pop"; string_of_int (counter+7)];
										String.concat " " ["pop"; string_of_int (counter+8)]]
									  @ (fst rtnt)),(snd rtnt)) in load_argument 0 arg in
	let argument_string = fst rule_string_and_length in
	let arglength = snd rule_string_and_length in 
	printf "the total argument fields for this rule is : %d \n" arglength;
	(*get expr list*)
	let rec find_local_index aname counter = function
		  [] -> counter
		| hd::tl -> if hd.pname = aname then counter else (if hd.ptp = "value" then (find_local_index aname (counter+1) tl) else (find_local_index aname (counter+9) tl)) in
	
	let rec nexpr = function
		  Num f -> [String.concat " " ["ldf"; string_of_float f]]
		| Bool b -> if b = "true" then ["ldf 1.0"] else ["ldf 0.0"]
		| Val vid -> let index = (find_local_index vid 0 arg) in  	printf "the location for value %s is : %d \n" vid index;
						if index > arglength  then raise (Failure ("undeclared variable" ^ vid)) else  [String.concat " " ["psh"; string_of_int index]] 
		| Tri_ele (tid, field) -> let tindex = (find_local_index tid 0 arg) in printf "%d st element of value %s is : %d \n" field tid (tindex+field);
						if tindex > arglength then raise (Failure ("undeclared variable" ^ string_of_int arglength)) else  [String.concat " " ["psh"; string_of_int (tindex+field)]] 
		| Binop2 (e1, op, e2)  -> 
					(match op with 
						| Minus -> nexpr e1 @ nexpr e2 @ ["sub"]
						| Plus -> nexpr e1 @ nexpr e2 @ ["add"]
						| Times -> nexpr e1 @ nexpr e2 @ ["mul"]
						| Divide -> nexpr e1 @ nexpr e2 @ ["div"])
		| Monop (op, npr) ->
					(match op with 
						| Sin -> nexpr npr @ ["sin"]
						| Cos -> nexpr npr @ ["cos"]
						| Tan -> nexpr npr @ ["tan"]
						| Arcs -> nexpr npr @ ["acs"]
						| Arcc -> nexpr npr @ ["acc"]
						| Arct -> nexpr npr @ ["act"]
						| Sqrt -> nexpr npr @ ["sqt"]) in
	let rec expr = function
		Binop (e1, op, e2)  -> 
			(match op with 
				| And -> expr e1 @ expr e2 @ ["and"]
				| Or -> expr e1 @ expr e2 @ ["or"]
				| Equal -> expr e1 @ expr e2 @ ["eql"]
				| Neq -> expr e1 @ expr e2 @ ["neq"]
				| Less -> expr e1 @ expr e2 @ ["les"]
				| Greater -> expr e1 @ expr e2 @ ["gtr"]
				| Leq -> expr e1 @ expr e2 @ ["leq"]
				| Geq -> expr e1 @ expr e2 @ ["geq"])
				| Rev ep -> expr ep @ ["not"]  
				| Nexpr nexp -> nexpr nexp			in
	
	
	let rule_string = argument_string @ List.rev argument_string in
	let rule_string = rule_string @ (expr condition) in
	let rule_string = rule_string @ ["bne 2"] @ ["rtn"] in
	let rule_string = rule_string @ nexpr stmt in
	let rule_string = rule_string @ ["rtn"] in
	(fprintf oc "%s\n" (String.concat "\n" rule_string));
	printf "the total argument fields for this rule is : %d \n" arglength;
	printf "the original offset for  this rule is : %d \n" offset;
	printf "the the length of rule_string is: %d \n" (List.length rule_string);
	printf "the offset for next rule is  is  : %d \n" (offset + (List.length rule_string));
	(arglength,((offset ) + (List.length rule_string)))  in



let rec entry_pair offset = function	
	  []->[] 
	| hd::tl -> let rtn = (translate hd (offset)) in
	 			let arglen = (fst rtn) and new_offset = (snd rtn) in
		(*print_int entrypoint;print_newline(); print_int arglen;print_newline(); print_int new_offset;print_newline();*)
		((offset + arglen), hd.rname) :: entry_pair new_offset tl in 
let pairs = (entry_pair 0 rule_decl) in
let rmap = string_map_rpairs (StringMap.empty) pairs in




let rec translate_operations operationlst = 
	let rec process_var = function 
		  [] -> []
		| hd :: tl ->  if hd.ptp = "value" then let  vindex = (StringMap.find hd.pname vmap) in 
										[String.concat " " ["lod"; string_of_int vindex]] @ (process_var tl)
										else let tindex = (StringMap.find hd.pname tmap) in 
										[String.concat " " ["lod"; string_of_int (tindex)];
										String.concat " " ["lod"; string_of_int (tindex+1)];
										String.concat " " ["lod"; string_of_int (tindex+2)];
										String.concat " " ["lod"; string_of_int (tindex+3)];
										String.concat " " ["lod"; string_of_int (tindex+4)];
										String.concat " " ["lod"; string_of_int (tindex+5)];
										String.concat " " ["lod"; string_of_int (tindex+6)];
										String.concat " " ["lod"; string_of_int (tindex+7)];
										String.concat " " ["lod"; string_of_int (tindex+8)]
										] @ (process_var tl) in


	let rec procnexpr = function
		Num f -> print_float f; [String.concat " " ["lod"; string_of_float f]]
		| Bool b -> if b = "true" then ["ldf 1.0"] else ["ldf 0.0"]
		| Val vid -> [String.concat " " ["lod"; string_of_int (StringMap.find vid vmap)]] 

		| Tri_ele (ttid, ffield) ->[String.concat " " ["lod"; string_of_int ((StringMap.find ttid tmap) + ffield)]] 

		| Binop2 (e1, op, e2)  -> 
			(match op with 
				| Minus -> procnexpr e1 @ procnexpr e2 @ ["sub"]
				| Plus -> procnexpr e1 @ procnexpr e2 @ ["add"]
				| Times -> procnexpr e1 @ procnexpr e2 @ ["mul"]
				| Divide -> procnexpr e1 @ procnexpr e2 @ ["div"])
		| Monop (op, npr) ->
			(match op with 
				| Sin -> procnexpr npr @ ["sin"]
				| Cos -> procnexpr npr @ ["cos"]
				| Tan -> procnexpr npr @ ["tan"]
				| Arcs -> procnexpr npr @ ["acs"]
				| Arcc -> procnexpr npr @ ["acc"]
				| Arct -> procnexpr npr @ ["act"]
				| Sqrt -> procnexpr npr @ ["sqt"]) 
		in
	
	let rec expr = function
		Binop (e1, op, e2)  -> 
			(match op with 
				| And -> expr e1 @ expr e2 @ ["and"]
				| Or -> expr e1 @ expr e2 @ ["or"]
				| Equal -> expr e1 @ expr e2 @ ["eql"]
				| Neq -> expr e1 @ expr e2 @ ["neq"]
				| Less -> expr e1 @ expr e2 @ ["les"]
				| Greater -> expr e1 @ expr e2 @ ["gtr"]
				| Leq -> expr e1 @ expr e2 @ ["leq"]
				| Geq -> expr e1 @ expr e2 @ ["geq"])
				| Rev ep -> expr ep @ ["not"]  
				| Nexpr np -> procnexpr np		in


					
	let oexpr = function
		  Expr exp -> expr exp
		| Rulec (rid, parlst) -> printf "%s" rid; let rindex = (StringMap.find rid rmap) in printf "a rull is called with id = %s and index = %d\n" rid rindex; (process_var parlst) @ [String.concat " " ["rc";string_of_int rindex]] in
								


		
	let rec operation = function
		  Block oplst -> translate_operations oplst
		| Prints str -> [String.concat " " ["pts"; str]]
		| Printv temp -> (expr temp) @ ["ptv"]
		| If (oxper, aoperation) -> let aoperation' = operation aoperation in
					(expr oxper) @ [String.concat " " ["beq" ;string_of_int (1 + List.length aoperation')]] @ aoperation'
		| Assign (id, oxper) -> printf "a assignment is called with id = %s \n" id; printf "a assignment is called with address of id = %d \n" (StringMap.find id vmap); 
				(oexpr oxper) @ (try [String.concat " " ["str"; string_of_int (StringMap.find id vmap)]] with Not_found -> raise (Failure ("Only value assignment allowed: undeclared variable" ^ id)))
		| While (oxper, aoperation) -> let aoperation' = operation aoperation and oxper' = expr oxper in
							[String.concat " " ["bra" ; string_of_int (1 + List.length aoperation')]] @ aoperation' @ oxper'@
							[String.concat " " ["bra" ; string_of_int (0 - (List.length aoperation' + List.length oxper'))]]  in 
	let rec enumopt = function
		  [] -> []
		| hd::tl -> (operation hd) @ (enumopt tl) in
	enumopt operationlst in 

let operation_string = ["opt"] @ ( translate_operations operations) @ ["hlt"]in
(fprintf oc "%s\n" (String.concat "\n" operation_string)) ;
	
	
close_out oc;
print_newline(); flush stdout;
	
	
	
	
	