open Parser
open Printf
open Scanner
open Semantics
open Codegen
open Dot
open Xdot

let _ =
  let cin =
  	if Array.length Sys.argv > 1
		then open_in Sys.argv.(1)
		else stdin 
	in (* Let's make sure we can parse a file *)
  let lexbuf = Lexing.from_channel cin in
  let ast = Parser.program Scanner.free_form lexbuf in
  (*fprintf out "digraph g {"; *)
  Dot.print_program ast ; 
  (*fprintf out "}" ; *)
  let sast, globals = Semantics.check_ast_type ast in
  (*fprintf out "digraph g {";*) 
  Xdot.print_program sast ; 
  (*fprintf out "}";*)
  let code = gen_prog sast globals
  in print_endline code
