type expr =
	Stmt of expr
	| Func of string
	| Id of string
	| Literal of int
	| Plus of expr * expr
	| Minus of expr * expr
	| Mult of expr * expr
	| Div of expr * expr
	| Mod of expr * expr
	| Eq of expr * expr
	| Ne of expr * expr
	| Lt of expr * expr
	| Lte of expr * expr
	| Gt of expr * expr
	| Gte of expr * expr
	| Band of expr * expr
	| Bor of expr * expr
	| Bxor of expr * expr
	| Lshift of expr * expr
	| Rshift of expr * expr
	| And of expr * expr
	| Or of expr * expr
	| Bnot of expr
	| Not of expr
	| Uminus of expr
	| Uplus of expr

type program = string
