open Xcommponents
open Printf
open Commponents


let out = open_out "sast.dot"
(* this function just print a simple type and connect it to its father
   retval: unit
*)
let print_single_type father string = 
  fprintf out "%d [label = %s];\n" (father+1) string;
  fprintf out "%d -> %d;\n" father (father+1);
  ()

(* this function just print a simple string and connect it to its father 
   retval: next available number
*)
let print_id father next_number string = 
  fprintf out "%d [label = %s];\n" (next_number) string;
  fprintf out "%d -> %d;\n" father (next_number);
  (next_number+1)

(* generic function to print lists *)
let rec list_printer root next_number func = function
  (* if there is nothing left to print just return the next available number *)
  | [] -> next_number
    
  (* otherwise head of the list is printed *)
  | head::tail -> let next = func root next_number head
		  in
		  (* recursion using the next available id *)
		  list_printer root next func tail

let print_bare_type father my_number bare_type = 
  fprintf out "#BARE_TYPE\n";
  fprintf out "%d [label = BARE_TYPE];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (my_number+1)

let print_binop father my_number oper = 
  fprintf out "#BINOP\n";
  fprintf out "%d [label = BINOP];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (my_number+1)

let print_unop father my_number oper = 
  fprintf out "#UNOP\n";
  fprintf out "%d [label = UNOP];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (my_number+1)

let rec print_rvalue father next_number rvalue = 
  match rvalue with
  | XExprRVal(xvartype,xexpr) -> print_expr father next_number xexpr 
  | XFuncRVal x -> print_anon father next_number x

and print_anon father my_number anon = 
  fprintf out "#ANON\n";
  (* create a node for the anon *)
  fprintf out "%d [label = anon];\n" my_number ;
  fprintf out "%d -> %d;\n" father my_number;
  let next = print_xfunc_dec_header (my_number) (my_number+1) (fst(anon)) in
  print_xblock my_number next (snd(anon))

	
and print_setting father my_number scope =
		let next = print_id father my_number "SCOPE" in
		let next = print_id  my_number next scope.own_func	in
		print_id my_number next (string_of_int scope.own_block )
	
and print_id_object father my_number obj =
  let next = print_id father (my_number) "id_object" in
  let next = print_id  (my_number) next obj.name in
  let next = print_vartype  my_number next obj.obj_type in
  let next = print_setting my_number next obj.scope_setting in
  fprintf out "%d[ label =\"FREE: %b\"];%d -> %d;\n" next obj.is_free my_number next;
		(next+1)

and print_xassignment father my_number xass = 
  fprintf out "%d [label = XASSIGNMENT];\n%d->%d;\n" my_number father my_number;  
    (* child for the lvalue list *)
  fprintf out "%d [label = l_values];\n%d->%d;\n" (my_number+1) my_number (my_number+1);
    (* child for the rvalue list *)
  fprintf out "%d [label = r_values];\n%d->%d;\n" (my_number+2) my_number (my_number+2);
    (* print the lvalues list *)
  let next = list_printer (my_number+1) (my_number+3) print_expr xass.lvals in
  let next = list_printer (my_number+2) next print_rvalue xass.rvals in
  (next)
	
and print_called_func father my_number called = 
	match(called) with
	| PrintCall -> print_id father my_number "PrintCall"
  | Double2IntCall -> print_id father my_number "Double2IntCall"
  | Int2DoubleCall -> print_id father my_number "Int2DoubleCall"
  | Boolean2IntCall -> print_id father my_number "Boolean2IntCall"
  | Int2BooleanCall -> print_id father my_number "Int2BooleanCall"
  | GenericCall(xexpr) -> (let next = print_id father my_number "GenericCall" in
			print_expr my_number next xexpr )

and print_stmt father my_number stmt = 
  fprintf out "#STMT\n";
  fprintf out "%d [label = STMT];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (* move indexes to attach everything under the STMT node *)
  let father = my_number
  and my_number = (my_number+1) in 
  match stmt with
  |  XBlock s -> print_xblock father my_number s 
  |  XAssignment (x) -> print_xassignment father my_number x
	| XFunctionCall (header,called ,rvalues) -> let next = print_id father my_number "XFunctionCall" in
			let next = print_xfunc_dec_header my_number next header in
	 	  let next = print_called_func my_number next called in 
			let _ = print_id my_number next "rvalues" in
			list_printer  next (next+1) print_rvalue rvalues 
 	| 	XReturn r -> (match(r) with
		| 	None -> my_number
		|   Some(r) -> print_rvalue father my_number r)
  | _ -> my_number
	
(*		
  | Declaration v -> print_var_dec father my_number v
  
  
  | ForBlock (sopt1, e, sopt2, sl) -> fprintf out "#FORBLOCK\n";
    let next = print_stmt_opt father my_number sopt1
  					in let next = print_expr_opt father next e
					in let next = print_stmt_opt father next sopt2
					in list_printer father next print_stmt sl
  | IfBlock (e, s) -> let next = (print_expr father my_number e)
  		      in print_async_stmt_list father next s
  | IfElseBlock (e, s1, s2) -> let next = (print_expr father my_number e)
  			       in let next = print_async_stmt_list my_number next s1
  			       in print_async_stmt_list my_number next s2
  | WhileBlock (e, s) -> fprintf out "#WHILEBLOCK\n";
    let next = (print_expr father my_number e)
    in print_async_stmt_list father next s
  | Break -> print_id father my_number "break"
  
*)

and print_expr father my_number expr =
  fprintf out "#EXPR\n";
  fprintf out "%d [label = EXPR];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  match expr with
  | XSingleConst (xvartype ,value) -> 
			let next = print_single_vartype my_number (my_number+1) xvartype in  
			let next = print_id  my_number next "single_constant" in 
			(match (value) with
			  | IntVal(x) -> fprintf out "%d[label=%d];\n%d->%d;\n" next x my_number next;
						(next+1)
				| _ -> next)
	| XFunkCallExpr (xvartype, func_call) ->
			(* let father = my_number            *)
			(* and my_number = (my_number+1) in  *)
			let next = print_id father my_number "XFunkCallExpr" in
		 	(*let next = print_vartype my_number next xvartype in *)
			(*let next = print_id my_number next "XFunCall" *)
			let (header,called ,rvalues) = func_call
			and father = (next-1)  in
			let next = print_xfunc_dec_header father (next) header in
	 	  let next = print_called_func father next called in 
			let _ = print_id father next "rvalues" in
			list_printer  next (next+1) print_rvalue rvalues 
  | XVariable v -> print_id_object my_number (my_number+1) v		
  |	_ -> (my_number+1)
(*  | ArrayLit (v,r) ->  let next = print_id my_number (my_number+1) "arraylit"
		       in let next = print_vartype (my_number+1) next v
			  in list_printer (my_number+1) next print_rvalue r
  
  | FunkUnExpr (u, e) -> let next = (print_expr my_number (my_number+1) e )
  			 in print_unop (my_number) next u
  | FunkBinExpr (e1, b, e2) -> let next = (print_expr my_number (my_number+1) e1 )
			       in let next = (print_binop my_number next b)
			       in print_expr (my_number) next e2
  | FunkArrExpr (e1, e2) -> let next = (print_expr my_number (my_number+1) e1 )
  			    in print_expr (my_number) next e2
  | FunkAsyncExpr s -> print_async_stmt_list  my_number (my_number+1) s
*)
and print_single_vartype father my_number typ  = 
  fprintf out "#SINGLE_VARTYPE\n";
  fprintf out "%d[label = single_vartype];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  match typ with
  | XFunkInt -> print_single_type my_number "int"; 
    (my_number+2)
  | XFunkChar -> print_single_type my_number "char";
    (my_number+2)
  | XFunkDouble -> print_single_type my_number "double";
    (my_number+2)
  | XFunkBool -> print_single_type my_number "bool";
    (my_number+2)
  | XFunkFunc x -> 
    print_xfunc_dec_header (my_number) (my_number+1) x
		
		(* print the attributes of a variable rooted at my_number *)
and print_var father next_number var = 
  fprintf out "#VAR\n";
  (* create a node for the var *)
  fprintf out "%d [label = var];\n" next_number ;
  fprintf out "%d -> %d;\n" father next_number;
  (* now print the type of the var *)
  let next = (next_number + 1)
  and father = (next_number)
  in print_vartype father next var.xbare_type

		
and print_vartype father my_number var= 
  fprintf out "#VARTYPE\n";
  fprintf out "%d[label = vartype];\n" my_number;
  fprintf out "%d -> %d;\n" father my_number ;
  let next = 
    (print_single_vartype my_number (my_number+1) (fst(var))  )
  in fprintf out "%d[label = \"expr list\"];\n" (next);
  fprintf out "%d -> %d;\n" my_number (next);
  (*print_expr_list next (next+1) (snd(var))*)
  list_printer next (next+1) print_expr (snd(var))

and print_xfunc_dec_header father my_number header = 
  fprintf out "#XFUNC_DEC_HEADER\n";
  fprintf out "%d [label=xfunc_dec_header];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (* print the return type if any *)
  let next =
    match header.xret_type with 
    | None -> (my_number+1)
    | Some(vartype) -> ( print_vartype my_number (my_number+1) vartype )
 
  (* then print the list of parameters *)    
  in 
  fprintf out "#next is %d\n" next;
  fprintf out "%d[label = params_list];\n%d -> %d;\n" next my_number next;
  (*attach the list of var on the params_list node *)
  list_printer (next) (next+1) print_var header.xparams

and print_need_copy father my_number free_obj =
  fprintf out "#invokd need copy father %d my_number %d\n" father my_number;
  let next = print_id father my_number "free_var" in
  let next = print_id_object (my_number) next (fst(free_obj)) in
  print_id_object (my_number) next (snd(free_obj))
  
	
and print_xblock father my_number block =
		let next = print_id father my_number "xblock" in
		(* xstmts node at my_number +1 *)
		let next = print_id my_number next "xstmts" in
		(* need_copy at my_number +2 *)
		let next = print_id my_number next "need_copy" in
		(* declared at my_number +3 *)
		let next = print_id my_number next "declared" in
		let next = list_printer (my_number+1) next print_stmt block.xstmts in
		let next = list_printer (my_number+2) next print_need_copy block.need_copy in
		list_printer (my_number+3) next print_id_object block.declared
		  

(* 
   print program and print declaration works a little bit differently for two reasons:
   - I coded them at the beginning
   - They are at the top of the tree
*)
let print_declaration father my_number p = 
  match p with
  | XVardec x -> 
    fprintf out "%d [label = XVardec];\n%d->%d;\n" my_number father my_number;  
    (* child for the lvalue list *)
    fprintf out "%d [label = l_values];\n%d->%d;\n" (my_number+1) my_number (my_number+1);
    (* child for the rvalue list *)
    fprintf out "%d [label = r_values];\n%d->%d;\n" (my_number+2) my_number (my_number+2);
    (* print the lvalues list *)
    let next = list_printer (my_number+1) (my_number+3) print_expr x.lvals in
    let next = list_printer (my_number+2) next print_rvalue x.rvals in
		(next)
  | XFuncdec x -> 
    fprintf out "%d [label = XFuncdec];\n%d->%d;\n" my_number father my_number; 
    (* print the function id *)
    (fprintf out "%d [label = \"id = %s\"]\n" (my_number+1) x.xfid);
    fprintf out "%d -> %d\n" my_number (my_number+1);
    (* print the func header *)
    let next = 
      	print_xfunc_dec_header (my_number) (my_number+2) x.xfunc_header 
    (* print the list of statements *)
    in 
    fprintf out "%d [label = stmt_list];\n" (next);
    fprintf out "%d->%d;\n" (my_number) (next);

    print_xblock (next) (next+1) x.xbody
    


let print_program p  = 
  fprintf out "digraph g{\n";
  fprintf out "0 [label= decl_list];\n";
  let _ = list_printer  0 1 print_declaration p in
  fprintf out "}\n"
