#include <env.h>

void *assign_async(void *data)
{
	struct async_assignment *assignment = (struct async_assignment *) data;
	struct var *lval = assignment->lval, *rval = assignment->rval;

	LOCK_VAR(rval);
	_shallow_copy(lval, rval);
	UNLOCK_VAR(rval);

	free(data);

	return NULL;
}
