open Parser
open Commponents
open Scanner
open Printf


let out = open_out "ast.dot"
(* this function just print a simple type and connect it to its father
   retval: unit
*)
let print_single_type father string = 
  fprintf out "%d [label = %s];\n" (father+1) string;
  fprintf out "%d -> %d;\n" father (father+1);
  ()

(* this function just print a simple string and connect it to its father 
   retval: next available number
*)
let print_id father next_number string = 
  fprintf out "%d [label = %s];\n" (next_number) string;
  fprintf out "%d -> %d;\n" father (next_number);
  (next_number+1)

(* generic function to print lists *)
let rec list_printer root next_number func = function
  (* if there is nothing left to print just return the next available number *)
  | [] -> next_number
    
  (* otherwise head of the list is printed *)
  | head::tail -> let next = func root next_number head
		  in
		  (* recursion using the next available id *)
		  list_printer root next func tail

let print_bare_type father my_number bare_type = 
  fprintf out "#BARE_TYPE\n";
  fprintf out "%d [label = BARE_TYPE];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (my_number+1)

let print_binop father my_number oper = 
  fprintf out "#BINOP\n";
  fprintf out "%d [label = BINOP];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (my_number+1)

let print_unop father my_number oper = 
  fprintf out "#UNOP\n";
  fprintf out "%d [label = UNOP];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (my_number+1)

let rec print_single_vartype father my_number typ  = 
  fprintf out "#SINGLE_VARTYPE\n";
  fprintf out "%d[label = single_vartype];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  match typ with
  | FunkInt -> print_single_type my_number "int"; 
    (my_number+2)
  | FunkChar -> print_single_type my_number "char";
    (my_number+2)
  | FunkDouble -> print_single_type my_number "double";
    (my_number+2)
  | FunkBool -> print_single_type my_number "bool";
    (my_number+2)
  | FunkFunc x -> 
    print_func_type_header (my_number) (my_number+1) x

and print_vartype father my_number var= 
  fprintf out "#VARTYPE\n";
  fprintf out "%d[label = vartype];\n" my_number;
  fprintf out "%d -> %d;\n" father my_number ;
  let next = 
    (print_single_vartype my_number (my_number+1) (fst(var)) )
  in fprintf out "%d[label = \"expr list\"];\n" (next);
  fprintf out "%d -> %d;\n" my_number (next);
  (*print_expr_list next (next+1) (snd(var))*)
  list_printer next (next+1) print_expr (snd(var))


and print_func_type_header father my_number header = 
  fprintf out "#FUNC_TYPE_HEADER\n";
  fprintf out "%d [label=func_type_header];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (* print the return type if any *)
  let next =
    match header.ret_type with 
    | None -> (my_number+1)
    | Some(vartype) -> ( print_vartype my_number (my_number+1) vartype )
 
  (* then print the list of parameters *)    
  in fprintf out "%d[label = params_list];\n%d -> %d;\n" next my_number next;
  (*attach the list of var on the params_list node *)
  list_printer (next) (next+1) print_var header.params

(* print the attributes of a variable rooted at my_number *)
and print_var father next_number var = 
  fprintf out "#VAR\n";
  (* create a node for the var *)
  fprintf out "%d [label = var];\n" next_number ;
  fprintf out "%d -> %d;\n" father next_number;
  (* print its id *)
  fprintf out "%d [label = \"%s\"];\n" (next_number+1) var.id ;
  fprintf out "%d -> %d;\n" (next_number) (next_number+1);
  (* now print the type of the var *)
  let next = (next_number + 2)
  and father = (next_number)
  in match var.bare_type with
  |Some(x) -> print_vartype father next x
  |None -> (next)

and print_anon father my_number anon = 
  fprintf out "#ANON\n";
  (* create a node for the anon *)
  fprintf out "%d [label = anon];\n" my_number ;
  fprintf out "%d -> %d;\n" father my_number;
  let next = print_func_type_header (my_number) (my_number+1) (fst(anon))
  (* notice how list root has to be printed by the caller - can change that*)
  in fprintf out "%d [label = stmt_list];\n" (next);
  fprintf out "%d->%d;\n" (my_number) (next);
  list_printer (next) (next+1) print_stmt (snd(anon ))

(* I hate you *)
and print_async_stmt_list father my_number st =
  fprintf out "%d [label = async_stmt_list];\n" (my_number);
  fprintf out "%d -> %d;\n" father my_number;
  list_printer (my_number) (my_number+1) print_stmt st

and print_func_call father  my_number fc =
  let next = print_id father my_number "func_call" 
  in
  (* print the function *)
  let next = (print_expr my_number next (fst(fc)) )
  (* print the arguments *)
  in fprintf out "%d[label = \"rvalue_list\"];\n%d -> %d;\n" next my_number next;
  list_printer (next) (next+1) print_rvalue (snd(fc))
      

(* double check this - bugs were there indeed *)
and print_expr father my_number expr =
  fprintf out "#EXPR\n";
  fprintf out "%d [label = EXPR];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  match expr with
  | SingleConst s -> let next = print_id my_number (my_number+1) "single_constant" in  
			(match (s) with
			  | IntVal(x) -> fprintf out "%d[label=%d];\n%d->%d;\n" next x (my_number+1) next;
						(next+1)
				| _ -> next
				)
  | ArrayLit (v,r) ->  let next = print_id my_number (my_number+1) "arraylit"
		       in let next = print_vartype (my_number+1) next v
			  in list_printer (my_number+1) next print_rvalue r
  | Variable v -> print_var my_number (my_number+1) v;
  | FunkUnExpr (u, e) -> let next = (print_expr my_number (my_number+1) e )
  			 in print_unop (my_number) next u
  | FunkBinExpr (e1, b, e2) -> let next = (print_expr my_number (my_number+1) e1 )
			       in let next = (print_binop my_number next b)
			       in print_expr (my_number) next e2
  | FunkCallExpr (e, r) -> print_func_call my_number (my_number+1) (e,r)
  | FunkArrExpr (e1, e2) -> let next = (print_expr my_number (my_number+1) e1 )
  			    in print_expr (my_number) next e2
  | FunkAsyncExpr s -> print_async_stmt_list  my_number (my_number+1) s

and print_var_dec father my_number v =
  fprintf out "%d [label = VAR_DEC];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  let next = list_printer (my_number) (my_number+1) print_id v.id_list
  in let next = print_vartype my_number next v.var_type
  in fprintf out "%d[label = \"rvalue_list\"];\n%d -> %d;\n" next my_number next;
  list_printer next (next+1) print_rvalue v.actual_list


and print_rvalue_option father next_number r =
  match r with
  | None -> fprintf out "%d [label = Return];\n" (next_number);
	    fprintf out "%d -> %d;\n" father (next_number);
	    (next_number+2)
  | Some(r) -> (print_rvalue father next_number r)

and print_stmt_opt father next_number s =
  fprintf out "#STMT_OPT\n";
  match s with
  | None -> next_number
  | Some(s) -> (print_stmt father next_number s)

and print_expr_opt father next_number e =
  match e with
  | None -> next_number
  | Some(e) -> (print_expr father next_number e)

and print_stmt father my_number expr = 
  fprintf out "#STMT\n";
  fprintf out "%d [label = STMT];\n" (my_number);
  fprintf out "%d -> %d;\n" father (my_number);
  (* move indexes to attach everything under the STMT node *)
  let father = my_number
  and my_number = (my_number+1)
  in
  match expr with
  | Assignment (e, r) -> fprintf out "#ASSIGNMENT\n";
    let next = list_printer father my_number print_expr e
    in list_printer father next print_rvalue r
  | Declaration v -> print_var_dec father my_number v
  | FunctionCall (e, r) -> print_func_call father my_number (e,r)
  | Block s -> print_async_stmt_list father my_number s
  | ForBlock (sopt1, e, sopt2, sl) -> fprintf out "#FORBLOCK\n";
    let next = print_stmt_opt father my_number sopt1
  					in let next = print_expr_opt father next e
					in let next = print_stmt_opt father next sopt2
					in list_printer father next print_stmt sl
  | IfBlock (e, s) -> let next = (print_expr father my_number e)
  		      in print_async_stmt_list father next s
  | IfElseBlock (e, s1, s2) -> let next = (print_expr father my_number e)
  			       in let next = print_async_stmt_list my_number next s1
  			       in print_async_stmt_list my_number next s2
  | WhileBlock (e, s) -> fprintf out "#WHILEBLOCK\n";
    let next = (print_expr father my_number e)
    in print_async_stmt_list father next s
  | Break -> print_id father my_number "break"
  | Return r -> print_rvalue_option father my_number r

(* rvalue is just a wrapper for either an anon or an expr *)
and print_rvalue father next_number rvalue = 
  match rvalue with
  | ExprRVal x -> print_expr father next_number x 
  | FuncRVal x -> print_anon father next_number x

(* 
   print program and print declaration works a little bit differently for two reasons:
   - I coded them at the beginning
   - They are at the top of the tree
*)
let print_declaration father my_number p = 
  match p with
  (* print the id list *)
  | Vardec x -> fprintf out "%d [label = Vardec];\n%d->%d\n" my_number father my_number;
    fprintf out "%d [label = id_list];\n%d->%d\n" (my_number+1) my_number (my_number+1); 
		let next = 
		  (* print_id_list (my_number+1) (my_number+2) x.id_list*)
		  list_printer (my_number+1) (my_number+2) print_id x.id_list
		(* print the vartype *)
		in let next =
		     print_vartype my_number next x.var_type
		   in
		   (* print the actual list *)
		   fprintf out "%d[label = \"rvalue_list\"];\n%d -> %d;\n" next my_number next;
		   (*print_actual_list next (next+1) x.actual_list*)
		   list_printer next (next+1) print_rvalue x.actual_list
		   (*next+1*)

  | Funcdec x -> fprintf out "%d [label = Funcdec];\n%d->%d\n" my_number father my_number; 
    (* print the function id *)
    (fprintf out "%d [label = \"id = %s\"]\n" (my_number+1) x.fid);
    fprintf out "%d -> %d\n" my_number (my_number+1);
    (* print the func header *)
    let next = print_func_type_header (my_number) (my_number+2) x.func_header 
    (* print the list of statements *)
    in fprintf out "%d [label = stmt_list];\n" (next);
    fprintf out "%d->%d;\n" (my_number) (next);
    list_printer (next) (next+1) print_stmt x.body
  
  | Newline x -> fprintf out "%d [label = Newline];\n%d->%d;\n" my_number father my_number ;
    my_number+1

let rec print_program p  = 
  fprintf out "digraph g{\n";
  fprintf out "0 [label= decl_list];\n";
  let _ = list_printer  0 1 print_declaration p in
  fprintf out "}\n"
 (*   match p with
   | [] -> fprintf out "0 [label= decl_list];\n}\n"
   | head::tail -> 
    (* here the children prints all his funny stuff *)
      let new_next = (print_declaration head next)
    (* and here gets connected to his beloved parent *)
       in (fprintf out "0 -> %d;\n" next); 
       print_program tail new_next 
 *)
(*  
let _ =
  let cin =
    if (Array.length Sys.argv) > 1 then open_in Sys.argv.(1) else stdin in
  (* Let's make sure we can parse a file *)
  let lexbuf = Lexing.from_channel cin in
  let program = Parser.program Scanner.free_form lexbuf
  in fprintf out "digraph g {"; print_program program 1; fprintf out "}"
*)
