module CharMap : sig
  type 'a t = 'a Map.Make(Char).t
end

module CharSet : sig
  type elt = Char.t
end


(* Problem 1 *)
val rle : 'a list -> ('a * int) list


(* Problem 2a *)
val free_vars : Ast.expr -> CharSet.elt list

(* Problem 2b *)
val eval : bool CharMap.t -> Ast.expr -> bool

(* Problem 2c *)
val string2tt : string -> string


(* Helper functions for Problem 2 *)

(* Parse a string, returning an expression *)
val string2expr : string -> Ast.expr

(* Pretty-print an expression; helpful for debugging *)
val string_of_expr : Ast.expr -> string

(* Given a list of variables, return a list of CharMaps (environments)
   that contain all possible Boolean assignments to the variables *)
val binary_envs : char list -> bool CharMap.t list

(* "0" or "1" *)
val string_of_bit : bool -> string
