module CharMap = Map.Make(Char)
module CharSet = Set.Make(Char)

open Ast

(* Helper functions; see hw1.mli for documentation *)

(* You shouldn't have to modify any of these, but you may if you wish *)

let string2expr str =
  let lexbuf = Lexing.from_string str in
  Parser.expr Scanner.token lexbuf

let rec string_of_expr = function
    Id(c) -> String.make 1 c
  | And(e1, e2) -> "(" ^ string_of_expr e1 ^ string_of_expr e2 ^ ")"
  | Or(e1, e2) -> "(" ^ string_of_expr e1 ^ "+" ^ string_of_expr e2 ^ ")"
  | Not(e) -> "(!" ^ string_of_expr e ^ ")"

let binary_envs vars =
  let rec tt env = function
     v :: vs -> (tt (CharMap.add v false env) vs) @
                (tt (CharMap.add v true env) vs)
    | [] -> [env]
  in tt CharMap.empty vars

let string_of_bit b = if b then "1" else "0"


(******************************************)
(* Your solutions should start below here *)
(******************************************)



(* Problem 1: Incorrect, but type is right *)
let rle l = 
  List.map (fun a -> (a, 1)) l

(* Problem 2a: Incorrect, but returns the correct type *)
let free_vars expr = ['C'; 'N']

(* Problem 2b: Incorrect, but returns the correct type *)
let eval env expr = false

(* Problem 2c: Incorrect, but returns something that looks right *)
let string2tt str = "00 0\n01 1\n10 1\n11 0"





