#include "AT91SAM7L128.h"
#include "lcd.h"
#include "keyboard.h"

int main()
{
  struct entry entry;
  // Disable the watchdog timer
  *AT91C_WDTC_WDMR = AT91C_WDTC_WDDIS;

  lcd_init();
  keyboard_init();

  lcd_print7("PRESS");

  keyboard_get_entry(&entry);

  lcd_put_char7(entry.operation, 7);
  lcd_put_char7(entry.number / 10 + '0', 9);
  lcd_put_char7(entry.number % 10 + '0', 10);

  for (;;) {
    int c = keyboard_key();
    lcd_put_char7(c > 0 ? c : ' ', 6);
  }

  return 0;
}
