#############################################################################
##         DATA REQUIRED BY TEST CODE -- DO NOT MODIFY
	      
	      .data
hello:	      .asciiz "Hello"
world:	      .asciiz "1World"
abc:	      .asciiz "abc?"
before:	      .asciiz "Before: "
return:	      .asciiz "Return: "
after:	      .asciiz "After: "
newline:      .asciiz "\n"
	      .text
	      .globl main

uppercase:    
##############################################################################
## Before changing string, scan for error

	      move  $t0, $a0                   # t0: pointer to current char
error_scan_top:	
	      lbu   $t1, 0($t0)                # t1: current char
	      beqz  $t1, error_scan_success    # if null, reached end of string w.o error, success!

# Processing regions of ASCII codd space from outside to inside
# t1 (char) could have any value ...
	      slti  $t2, $t1, 48               # if char < 48 
	      bnez  $t2, error_scan_fail
	      addi  $t2, $t1, -122             # if char > 122
	      bgtz  $t2, error_scan_fail

# We now know that 48 <= t1 <= 122 ...
	      slti  $t2, $t1, 58	       # if char < 58
	      bnez  $t2, error_scan_advance
	      addi  $t2, $t1, -96	       # if char > 96
	      bgtz  $t2, error_scan_advance

# We now know that 58 <= t1 <= 96 ...
	      slti  $t2, $t1, 65	       # if char < 65
	      bnez  $t2, error_scan_fail
	      addi  $t2, $t1, -90	       # if char > 90
	      bgtz  $t2, error_scan_fail

# we now know that 65 <= t1 <= 90, which is valid, so fall through and advance
error_scan_advance:
	      addi  $t0, $t0, 1                # advance to next char
	      b	    error_scan_top
	      
error_scan_fail:
	      li $v0, 1
	      jr    $ra

##############################################################################
## If scan succeeds, start upper-casing
error_scan_success:
	      move  $t0, $a0		       # start over at beginning of string
uppercasing_top: 
	      lbu   $t1, 0($t0)		       # get char again
	      beqz  $t1, uppercasing_done      # if null, reached end of string, done!

	      slti  $t2, $t1, 97               # charcter does not need to be capitalized
	      bnez  $t2, uppercasing_advance

	      addi  $t1, $t1, -32              # convert to uppercase
	      sb    $t1, 0($t0)                # update character in memory
	      
uppercasing_advance:
	      addi  $t0, $t0, 1		       # advance to next char
	      b	    uppercasing_top
  
uppercasing_done:
	      li $v0, 0
	      jr    $ra

##########################################################################
##            TEST CODE -- DO NOT MODIFY BELOW THIS LINE                      

print_string: 
	      li    $v0, 4
	      syscall
	      jr    $ra

print_int:    li    $v0, 1
	      syscall
	      jr    $ra

test_uppercase:
	      addi $sp, $sp, -12   # save preserved state
	      sw    $s0, 0($sp)
	      sw    $s1, 4($sp)
	      sw    $ra, 8($sp)

	      move  $s0, $a0      # save pointer to string, bc. about to make calls
	      la    $a0, before
	      jal   print_string  # print "Before: "
	      move  $a0, $s0
	      jal   print_string  # print "<string>"
	      la    $a0, newline
	      jal   print_string  # print "\n"

	      move  $a0, $s0
	      jal   uppercase     # call uppercase function
	      move  $s1, $v0      # save result to $s1
	      
	      la    $a0, return
	      jal   print_string  # print "Return: "
	      move  $a0, $s1
	      jal   print_int     # print "<return val>"
	      la    $a0, newline
	      jal   print_string  # print "\n"

	      la    $a0, after
	      jal   print_string  # print "After: "
	      move  $a0, $s0
	      jal   print_string  # print "<string>"
	      la    $a0, newline
	      jal   print_string  # print "\n"
      
	      lw    $s0, 0($sp)	  # restore state
	      lw    $s1, 4($sp)	
	      lw    $ra, 8($sp)
	      addi  $sp, $sp, 12
	      jr    $ra           # return
	      
main:
	      la    $a0, hello
	      jal   test_uppercase
 	      la    $a0, world
 	      jal   test_uppercase
 	      la    $a0, abc
 	      jal   test_uppercase

	      li    $v0, 10              # exit
	      syscall

	
