#############################################################################
##         .DATA REQUIRED BY TEST CODE -- DO NOT MODIFY
	      
	      .data

tiny:	      .word 1, tiny1, tiny2
tiny1:	      .word 2, 0, 0
tiny2:	      .word 3, 0, 0	      
	      
tree:	      .word 31, tree1, tree2
tree1:	      .word 45, tree3, tree4
tree2:	      .word 62, tree5, 0
tree3:	      .word 25, 0, 0
tree4:	      .word 34, 0, 0
tree5:	      .word 0, 0, 0
	      
lbracket:     .asciiz " { "
rbracket:     .asciiz " } "	     

input:        .asciiz "Input: "
sum:	      .asciiz "Sum: "
newline:      .asciiz "\n"
	      
	      .text
	      .globl main

tree_sum:
	      bnez $a0, tree_sum_recurse
	      li    $v0, 0
	      jr $ra

tree_sum_recurse: 
	      addi  $sp, $sp, -12        # going to have to recurse, so save state
	      sw    $ra, 0($sp)
	      sw    $s0, 4($sp)
	      sw    $s1, 8($sp)	      
	      move  $s0, $a0             # s0: node address
	      
  	      lw    $s1, 0($s0)          # s1: subtree sum initialized w. value of this node

  	lw    $a0, 4($s0)	         # recurse on first child
	      jal   tree_sum
	      add   $s1, $s1, $v0        # add in first subtree sum
  
	      lw    $a0, 8($s0)	         # recurse on second child
	      jal   tree_sum
	      add   $v0, $s1, $v0        # add in second subtree sum

	      lw    $ra, 0($sp)
	      lw    $s0, 4($sp)
	      lw    $s1, 8($sp)
	      addi  $sp, $sp, 12         # restore state & return
	      jr    $ra
	      
##########################################################################
##            TEST CODE -- DO NOT MODIFY BELOW THIS LINE                      

print_string: 
	      li    $v0, 4
	      syscall
	      jr    $ra

print_int:    li    $v0, 1
	      syscall
	      jr    $ra
	      
print_tree:
	      bnez $a0, print_tree_recurse
	      jr $ra
print_tree_recurse:                    
	      addi  $sp, $sp, -8        # going to have to recurse, so save state
	      sw    $ra, 0($sp)
	      sw    $s0, 4($sp)
	      move  $s0, $a0             # s0: node address

	      la    $a0, lbracket        # print open bracket
	      jal   print_string
	      
	      lw    $a0, 0($s0)          # print value of node
	      jal   print_int

  	      lw    $a0, 4($s0)	         # recurse on first child
	      jal print_tree
  
	      lw    $a0, 8($s0)	         # recurse on second child
	      jal print_tree

	      la    $a0, rbracket        # print open bracket
	      jal   print_string
	      
	      lw    $ra, 0($sp)          # restore state & return
	      lw    $s0, 4($sp)
	      addi  $sp, $sp, 8
	      jr    $ra
	      

test_tree_sum: 
	      addi $sp, $sp, -12   # save preserved state
	      sw    $s0, 0($sp)
	      sw    $s1, 4($sp)
	      sw    $ra, 8($sp)

	      move  $s0, $a0      # save pointer to tree

	      la    $a0, input    # print input tree
	      jal   print_string
	      move  $a0, $s0
	      jal   print_tree
	      la    $a0, newline
	      jal   print_string

	      move  $a0, $s0      # call tree_sum
	      jal   tree_sum
	      move  $s1, $v0

	      la    $a0, sum      # print sum
	      jal   print_string
	      move  $a0, $s1
	      jal   print_int     
	      la    $a0, newline
	      jal   print_string  
	      
	      lw    $s0, 0($sp)	  # restore state
	      lw    $s1, 4($sp)	
	      lw    $ra, 8($sp)
	      addi  $sp, $sp, 12
	      jr    $ra           # return
	      
main:
	      la    $a0, tiny
	      jal   test_tree_sum

	      la    $a0, tree
	      jal   test_tree_sum
	      
	      li    $v0, 10              # exit
	      syscall

	
	      