#!/bin/bash

for file in `ls *gaq`
do
 pathfilename=${file%.*}
 echo "Running test $pathfilename"
 # echo $pathfilename
 ../gaq -c < $file > ${pathfilename}.new.cpp 
 if [ $? -ne 0 ]; then
    echo "Compilation failed! Test $pathfilename failed!"
    continue
 fi
 diff ${pathfilename}.new.cpp ${pathfilename}.cpp > ${pathfilename}.diff
 if [ $? -ne 0 ]; then
    echo "Output of compilation is different, Test $pathfilename failed!"
    continue
 fi
 echo "Test $pathfilename passed!"
done
