(* Author Ayla Brayer *)
{ open Parser }

rule token = parse 
   [' ' '\t' '\r' '\n'] { token lexbuf }
|  "/*"	     	  	{ comment lexbuf }
|  '('			{ LPAREN }
|  ')'			{ RPAREN }
|  '['			{ RSBRACE }
|  ']'			{ LSBRACE }
|  '{'			{ LBRACE }
|  '}'			{ RBRACE }
|  ';'			{ SEMI }
|  '+'			{ PLUS }
|  '*'			{ TIMES }
|  '='			{ ASSIGN }
|  "=="         { EQ }
|  "!="			{ NEQ }
|  "<="			{ LEQ }
|  ">="			{ GEQ }
|  '<'			{ LT }
|  '>'			{ GT }
|  '-'			{ MINUS }
|  '/'			{ DIVIDE }
|  '&'			{ AND }
|  '|'			{ OR }
|  "default"	{ DEFAULT }
|  "repeat"		{ REPEAT }
|  "print"      { PRINT }
|  "int"		{ INT }
|  "float"      { FLOAT }
|  "string"		{ STRING }
|  "bool"		{ BOOL }
|  "true"		{ TRUE(true) }
|  "false"	    { FALSE(false) }
|  ['0'-'9']+ as n	{ LITERAL(int_of_string n) } (*integers*)
(*floating points*)
|  (['0'-'9']+ ?)'.'['0'-'9']+('e' ('+'|'-')?['0'-'9']+)? as lxm {FLOATPT(float_of_string lxm) } 
|  ['0'-'9']+('.')(['0'-'9']+ ?)('e' ('+'|'-')?['0'-'9']+)?  as lxm {FLOATPT(float_of_string lxm) }
|  ['0'-'9']+('e' ('+'|'-')?['0'-'9']+) as lxm {FLOATPT(float_of_string lxm) }
|  ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }  (*identifiers*)
|  '\"'[^'\"']*'\"'   as lxm { STR(lxm) } (* strings *)
|  eof		{ EOF } 
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) } 

(*ignore comments*)
and comment = parse
  "*/" { token lexbuf }
| _    { comment lexbuf }



