(* Author Ayla Brayer and Esther Kundin *) 
open Compile

type action = Ast | Compile

(* main compilation program *)
let _ = 
   let action = if Array.length Sys.argv > 1 then
	List.assoc Sys.argv.(1) [("-a", Ast); 
	                         ("-c", Compile)]
							 
	else Compile in
	
	let lexbuf = Lexing.from_channel stdin in 
	let program = Parser.program Scanner.token lexbuf in
	
	match action with 
	     (* print ast *)
	     Ast -> let listing = Ast.string_of_program program
				in print_string listing
		 (* compile *)           
	   | Compile ->  Compile.compile (program) 
	   
