%{ open Ast %}

%token SEMI LPAREN RPAREN LBRACE RBRACE COMMA
%token PLUS MINUS TIMES DIVIDE POW SQRT ASSIGN
%token EQ NEQ STREQ LT LEQ GT GEQ CONCAT
%token NOT AND OR
%token IF ELSE FOR WHILE
%token BOOLEAN INT DECIMAL STRING
%token <string> LITERAL
%token <string> ID
%token <string> STR
%token EOF
%token FUNCTION VEHICLE PEDESTRIAN TRAFFICSIGNAL STOPSIGN OBJECT
%token DEREFERENCE
%token PRINT RANDOM

%nonassoc NOELSE
%nonassoc ELSE
%nonassoc RANDOM

%left ASSIGN
%left NOT AND OR
%left EQ NEQ STREQ
%left LT GT LEQ GEQ
%left CONCAT
%left PLUS MINUS
%left TIMES DIVIDE
%left POW SQRT
%nonassoc NEG

%start program
%type <Ast.program> program

%%

program:
  /* nothing */        					{ [], [] }
  | program vdecl      					{ ($2 :: fst $1), snd $1 }
  | program fdecl      					{ fst $1, ($2 :: snd $1) }

fdecl:
  FUNCTION ID LPAREN formals_opt RPAREN LBRACE vdecl_list stmt_list RBRACE
     							{ { fname = $2;
	 						    formals = $4;
	 						    locals = List.rev $7;
	 						    body = List.rev $8 } }

formals_opt:
  /* nothing */ 					{ [] }
  | formal_list   					{ List.rev $1 }

formal_list:
  ID                       				{ [$1] }
  | formal_list COMMA ID    				{ $3 :: $1 }

vdecl_list:
  /* nothing */  					{ [] }
  | vdecl_list vdecl 					{ $2 :: $1 }

vdecl:
  OBJECT ID LPAREN attr_opt RPAREN SEMI 		{ { vtype = "Object"; 
  							    vname = $2; vattrs = $4;} } 
  | VEHICLE ID LPAREN attr_opt RPAREN SEMI 		{ { vtype = "Vehicle"; 
  							    vname = $2; vattrs = $4;} } 
  | PEDESTRIAN ID LPAREN attr_opt RPAREN SEMI 		{ { vtype = "Pedestrian"; 
  							    vname = $2; vattrs = $4;} } 
  | TRAFFICSIGNAL ID LPAREN attr_opt RPAREN SEMI 	{ { vtype = "TrafficSignal"; 
  							    vname = $2; vattrs = $4;} } 
  | STOPSIGN ID LPAREN attr_opt RPAREN SEMI 		{ { vtype = "StopSign"; 
  							    vname = $2; vattrs = $4;} } 
              
attr_opt:
  /* nothing */                 			{ [] }
  | attr_list                      			{ $1 }

attr_list:
  attr                         				{ [$1] }
  | attr_list COMMA attr          			{ $3 :: $1 }

attr:
  STRING ID ASSIGN STR    				{ { key = $2; 
  							    value = String.sub $4 1 ((String.length $4)-2);} }

  | STRING ID     					{ { key = $2; value = "";} }
  
  | DECIMAL ID ASSIGN MINUS LITERAL			{ { key = $2; 
  							    value = string_of_float (-.(float_of_string $5));} }

  | DECIMAL ID ASSIGN LITERAL    			{ { key = $2; value = $4;} }

  | DECIMAL ID     					{ { key = $2; value = "0.0";} }

  | INT ID ASSIGN MINUS LITERAL				{ { key = $2; 
  							    value = string_of_float (-.(float_of_string $5));} }

  | INT ID ASSIGN LITERAL    				{ { key = $2; value = $4;} }

  | INT ID     						{ { key = $2; value = "0";} }

  | BOOLEAN ID ASSIGN LITERAL    			{ { key = $2; value = $4;} }

  | BOOLEAN ID			    			{ { key = $2; value = "true";} }

stmt_list:
  /* nothing */  					{ [] }
  | stmt_list stmt 					{ $2 :: $1 }

stmt:
  expr SEMI 						{ Expr($1) }

  | LBRACE stmt_list RBRACE 				{ Block(List.rev $2) }

  | IF LPAREN objexpr RPAREN stmt %prec NOELSE 
  							{ If($3, $5, Block([])) }

  | IF LPAREN objexpr RPAREN stmt ELSE stmt    
  							{ If($3, $5, $7) }

  | FOR LPAREN objexpr_opt SEMI objexpr_opt SEMI objexpr_opt RPAREN stmt
  							{ For($3, $5, $7, $9) }

  | WHILE LPAREN objexpr RPAREN stmt 			{ While($3, $5) }

  | PRINT objexpr SEMI      				{ Print($2) }

expr:
  ID                                        		{ Id($1) }
  | ID DEREFERENCE ID ASSIGN objexpr     		{ Assign($1, $3, $5) }   
  | ID LPAREN actuals_opt RPAREN            		{ Call($1, $3) }
  | LPAREN expr RPAREN                      		{ $2 }

objexpr_opt:
  /* nothing */ 					{ Noexpr }
  | objexpr          					{ $1 }

objexpr:
  LITERAL                                     		{ Literal($1) }
  | STR                                       		{ Str($1) } 
  | MINUS objexpr %prec NEG 		      		{ Neg($2) }
  | objexpr PLUS objexpr                		{ Binop($1, Add, $3) }
  | objexpr MINUS objexpr               		{ Binop($1, Sub, $3) }
  | objexpr TIMES objexpr               		{ Binop($1, Mult, $3) }
  | objexpr DIVIDE objexpr              		{ Binop($1, Div, $3) }
  | objexpr POW objexpr                 		{ Binop($1, Pow, $3) }
  | objexpr EQ objexpr                  		{ Binop($1, Equal, $3) }
  | objexpr NEQ objexpr                 		{ Binop($1, Neq, $3) }
  | objexpr LT objexpr                  		{ Binop($1, Less, $3) }
  | objexpr LEQ objexpr                 		{ Binop($1, Leq, $3) }
  | objexpr GT objexpr                  		{ Binop($1, Greater, $3) }
  | objexpr GEQ objexpr                 		{ Binop($1, Geq, $3) }
  | objexpr CONCAT objexpr              		{ Binop($1, Concat,  $3) }
  | objexpr AND objexpr 		      		{ Binop($1, And, $3) }
  | objexpr OR objexpr 		      			{ Binop($1, Or, $3) }
  | STREQ LPAREN objexpr COMMA objexpr RPAREN
  							{ Streq($3, $5) }
  | NOT objexpr 		      	      		{ Not($2) }
  | SQRT objexpr      	      	      			{ Sqrt($2) }
  | RANDOM objexpr      	      	      		{ Random($2) }
  | ID DEREFERENCE ID ASSIGN objexpr       		{ ObjAssign($1, $3, $5) } 
  | ID DEREFERENCE ID                      	   	{ Attribute($1, $3) }
  | LPAREN objexpr RPAREN                  		{ $2 }

actuals_opt:
    /* nothing */ 					{ [] }
  | actuals_list  					{ List.rev $1 }

actuals_list:
    expr                    				{ [$1] }
  | actuals_list COMMA expr 				{ $3 :: $1 }
