type op = Add | Sub | Mult | Div | Pow | Equal | Neq | Less | Leq | Greater 
	  | Geq | Concat | And | Or

(* object expressions *)
type objexpr =          				
  Literal of string    
  | Noexpr
  | Str of string      
  | Neg of objexpr
  | Binop of objexpr * op * objexpr
  | Streq of objexpr * objexpr
  | Not of objexpr
  | Sqrt of objexpr
  | Random of objexpr
  | ObjAssign of string * string * objexpr
  | Attribute of string * string   
    
(* expressions *)
type expr =           					
  Id of string         
  | Assign of string * string * objexpr    
  | Call of string * expr list     

(* statements *)
type stmt =
  Expr of expr
  | Block of stmt list
  | If of objexpr * stmt * stmt
  | For of objexpr * objexpr * objexpr * stmt
  | While of objexpr * stmt
  | Print of objexpr
    
(* variable attribute declarations *)
type attr_decl = {
  key   : string;         		(* attribute key *)
  value : string;                  	(* attribute value *)
}

(* variable declarations *)
type var_decl = {
  vtype  : string;        	 	(* variable type *)
  vname  : string;                 	(* variable name *) 
  vattrs : attr_decl list;         	(* variable attributes *)        
}  
  
(* function declarations *)
type func_decl = {
    fname   : string;     	    	(* function name *)
    formals : string list;         	(* function arguments *)
    locals  : var_decl list;         	(* list of local variables *)
    body    : stmt list;         	(* list of statements *)
}

(* the program *)
type program = var_decl list * func_decl list
