(* Fundamental types and operators for Markush Description Language *)

type mdl_type =
	| Int
	| Mol
	| Atom
	| Bond
	| String
	| Boolean
	| Tuple of mdl_type

type op =
	| Add
	| Sub
	| Mult
	| Div
	| Equal
	| Neq
	| Less
	| Leq
	| Greater
	| Geq
	| Not

exception MDLException of string

let rec string_of_type =
	function
	| Int -> "int"
	| Mol -> "Mol"
	| Atom -> "Atom"
	| Bond -> "Bond"
	| String -> "String"
	| Boolean -> "Boolean"
	| Tuple(t) -> (string_of_type t) ^ " []"

let rec type_of_tuple =
	function
	| Int | Mol | Atom | Bond | String | Boolean | Tuple(Tuple _) ->
			raise (MDLException "Type being check not a Tuple")
	| Tuple(Int) -> Int
	| Tuple(Mol) -> Mol
	| Tuple(Atom) -> Atom
	| Tuple(Bond) -> Bond
	| Tuple(String) -> String
	| Tuple(Boolean) -> Boolean

let string_of_operator =
	function
	| Add -> "+"
	| Sub -> "-"
	| Mult -> "*"
	| Div -> "/"
	| Equal -> "=="
	| Neq -> "!="
	| Less -> "<"
	| Leq -> "<="
	| Greater -> ">"
	| Geq -> ">="
	| Not -> "!"

