type action = | Ast | Compile

let _ =
	let action =
		if (Array.length Sys.argv) > 1
		then List.assoc Sys.argv.(1) [ ("-a", Ast); ("-c", Compile) ]
		else Compile in
	let lexbuf = Lexing.from_channel stdin in
	let program = Parser.program Scanner.token lexbuf
	in
	match action with
	| Ast ->
			print_string (Mdlpp.string_of_program program)
	| Compile ->
			print_string (Compile.translate (Semantics.check_prog program))
