(* Java AST for cross compilation from MDL to Java *)

type scope = Global | Method | Formal | ForLoop

type var_decl = {
		vtype : Types.mdl_type;
		vname : string;
		vscope : scope;
	}

type expr_detail = 
	(* primary expressions *)
	| Id of var_decl
	| IntLiteral of int
	| ChemLiteral of string
	| StringLiteral of string
	| BooleanLiteral of bool
	| Call of method_decl * typed_expr list

	(* Unary operators *)
	| Unop of Types.op * typed_expr

	(* Binary operators *)
	| Binop of typed_expr * Types.op * typed_expr
  | Covers of typed_expr * typed_expr

	(* Assignment operator *)
  | Assign of var_decl * typed_expr

	(* List operator *)
  | List of typed_expr list

and typed_expr = expr_detail * Types.mdl_type

and stmt =
  | Block of stmt list
  | Expr of typed_expr
  | For of var_decl * typed_expr * stmt 
  | While of typed_expr * stmt
	| IfThenElse of typed_expr * stmt * stmt
	| IfThen of typed_expr * stmt
	| Return of typed_expr

and method_decl = {
  	rettype: Types.mdl_type;
    fname : string;
    formals : var_decl list;
    locals : var_decl list;
    body : stmt list;
  }

type java_class = 
	| JClass of var_decl list * method_decl list
