(* AST for Markush Description Language *)

type expr = 
	(* primary expressions *)
  | Id of string 
  | IntLiteral of int
	| ChemLiteral of string
	| StringLiteral of string
	| BooleanLiteral of bool
  | Call of string * expr list

	(* Unary operators *)
	| Unop of Types.op * expr

	(* Binary operators *)
  | Binop of expr * Types.op * expr
	| Covers of expr*expr

	(* Assignment operator *)
  | Assign of string*expr

	(* List operator *)
  | List of expr list
  
type stmt =
  | Block of stmt list
  | Expr of expr
  | For of Types.mdl_type*string*expr*stmt 
  | While of expr*stmt
	| IfThenElse of expr*stmt*stmt
	| IfThen of expr*stmt
	| Return of expr
  
type func_decl = {
  	rettype: Types.mdl_type;
    fname : string;
    formals : (Types.mdl_type*string) list;
    locals : (Types.mdl_type*string) list;
    body : stmt list;
  }
  
type program = (Types.mdl_type*string) list * func_decl list
