import static org.junit.Assert.assertEquals;

import java.util.Arrays;

import openeye.oechem.OEGraphMol;
import openeye.oechem.oechem;

import org.junit.Test;

public class RxnUtilsTest {
	@Test
	public void test_replaceRZ() {
		assertEquals("C(%81)[R2]", 
				RxnUtils.replaceRZ("[R1]C[R2]", 
						RxnUtils.R_PATTERN, Arrays.asList(1)));

		assertEquals("C([R1])%82", 
				RxnUtils.replaceRZ("[R1]C[R2]", 
						RxnUtils.R_PATTERN, Arrays.asList(2)));

	}

	/**
	 * Proves the RxnUtils.joinFrags works for two-step joining of fragments
	 */
	@Test
	public void test_joinFrags() {
		OEGraphMol core = new OEGraphMol();
		oechem.OEParseSmiles(core, "[R1]c1cccc([R2])n1");

		OEGraphMol rg1 = new OEGraphMol();
		oechem.OEParseSmiles(rg1, "[R1]N");
		
		OEGraphMol rg2 = new OEGraphMol();
		oechem.OEParseSmiles(rg2, "[R2]C(=O)O");

		OEGraphMol [] mols = RxnUtils.joinFrags(new OEGraphMol[] {core}, 
				new OEGraphMol [] {rg1});
		mols = RxnUtils.joinFrags(mols, new OEGraphMol [] {rg2});
		
		assertEquals("c1cc(nc(c1)N)C(=O)O", oechem.OECreateIsoSmiString(mols[0]));
	}

}
