/*
 * Houtan Fanisalek
 * Copyright (c) 2011
 */
package hootie.firms;

import hootie.connector.Stock;
import hootie.connector.StockTradeAPI;
import hootie.exceptions.BadSymbol;
import hootie.exceptions.InsufficientFunds;
import hootie.exceptions.NotInPortfolio;

/**
 *
 * @author Houtan Fanisalek
 */
public class TestTradingFirm extends StockTradeAPI {

    @Override
    public synchronized void print(String output) {
        System.out.println(output);
    }

    @Override
    public synchronized Stock lookup(String stock) throws BadSymbol {
        Stock s = new Stock();
        if (stock.equalsIgnoreCase("$NFLX")) {
            s.price = 250.0;
            s.volume = 20000000;
        } else if (stock.equalsIgnoreCase("$AIG")) {
            s.price = 24.0;
            s.volume = 44444444;
        } else {
            throw new BadSymbol(stock);
        }
        return s;
    }

    @Override
    public synchronized boolean buy(String stock, int quant)
            throws BadSymbol, InsufficientFunds {

        if (stock.equalsIgnoreCase("$NFLX")) {
            throw new InsufficientFunds();
        } else if (stock.equalsIgnoreCase("$AIG")) {
            return true;
        } else {
            throw new BadSymbol(stock);
        }
    }

    @Override
    public synchronized boolean sell(String stock, int quant)
            throws BadSymbol, NotInPortfolio {

         if (stock.equalsIgnoreCase("$NFLX")) {
            throw new NotInPortfolio(stock);
        } else if (stock.equalsIgnoreCase("$AIG")) {
            return true;
        } else {
            throw new BadSymbol(stock);
        }
    }
}
