{ open Parser }

rule token = parse
  [' ' '\t' '\r' '\n'] { token lexbuf } (* Whitespace *)
| "//"     	{ comment lexbuf }           (* Comments *)
| '@'		{ AMP }
| '('      	{ LPAREN }
| ')'      	{ RPAREN }
| '{'      	{ LBRACE }
| '}'      	{ RBRACE }
| ';'      	{ SEMI }
| ','      	{ COMMA }
| '+'      	{ PLUS }
| '-'      	{ MINUS }
| '*'      	{ TIMES }
| '/'      	{ DIVIDE }
| '='      	{ ASSIGN }
| "AND"		{ AND }
| "OR"		{ OR }
| "NOT"		{ NOT }
| "EQUALS" 	{ EQ }
| "!="     	{ NEQ }
| '<'      	{ LT }
| "<="     	{ LEQ }
| ">"      	{ GT }
| ">="     	{ GEQ }
| "WHEN"   	{ IF }
| "OTHERWISE"   { ELSE }
| "LOOP"   	{ WHILE }
| "BREAKOUT" 	{ RETURN }
| "BUY"		{ BUY }
| "SELL"	{ SELL }
| "EXECUTE" 	{ EXECUTE }
| "IS"		{ IS }
| "PRICE"	{ PRICE }
| "VOLUME"	{ VOLUME }
| "MCAP"	{ MCAP }
| "BETA"	{ BETA }
| "RANGE"	{ RANGE }
| "LOOKUP"	{ LOOKUP }
| "WAIT"	{ WAIT }
| "WAITEXE"	{ WAITEXE }
| "EXIT"	{ EXIT }
| "PRINT"	{ PRINT }
| "TRUE"	{ TRUE }
| "FALSE"	{ FALSE }
| ['"']['a'-'z' 'A'-'Z' '0'-'9' '_' ' ']*['"'] as lxm { TEXT(lxm) }
| ['0'-'9']+ as lxm { LITERAL(int_of_string lxm) }
| ['0'-'9']*['.']['0'-'9']* as lxm { FLOAT (float_of_string lxm) }
| '$'['A'-'Z']+ as lxm { SYMBOL(lxm) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  "//" { token lexbuf }
| _    { comment lexbuf }

