%{ open Ast %}

%token BUY SELL EXECUTE LOOKUP EXIT PRINT
%token WAIT WAITEXE
%token IS PRICE VOLUME MCAP BETA RANGE
%token <string> SYMBOL
%token SEMI LPAREN RPAREN LBRACE RBRACE COMMA
%token PLUS MINUS TIMES DIVIDE ASSIGN
%token EQ NEQ LT LEQ GT GEQ
%token AND OR NOT TRUE FALSE
%token RETURN IF ELSE FOR WHILE AMP
%token <float> FLOAT
%token <int> LITERAL
%token <string> ID
%token <string> TEXT
%token EOF

%nonassoc NOELSE
%nonassoc ELSE

%left ASSIGN
%left IS
%left EQ NEQ
%left AND OR NOT
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE

%start program
%type <Ast.program> program

%%

program:
   /* nothing */ { [], [] }
 | program vdecl { ($2 :: fst $1), snd $1 }
 | program fdecl { fst $1, ($2 :: snd $1) }

fdecl:
   EXECUTE ID LBRACE vdecl_list stmt_list RBRACE
     { { fname = $2;
	 locals = List.rev $4;
	 body = List.rev $5 } }

vdecl_list:
    /* nothing */    { [] }
  | vdecl_list vdecl { $2 :: $1 }

vdecl:
   AMP ID SEMI { $2 }

stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

cmpr:
	   { ".price"  }
  | VOLUME { ".volume" }
  | PRICE  { ".price"  }
  | MCAP   { ".mcap"   }
  | BETA   { ".beta"   }
  | RANGE  { ".range"  }

stmt:
    expr SEMI { Expr($1) }
  | RETURN SEMI { Return }
  | WAITEXE stmt { Waitexe($2) }
  | WAIT LITERAL SEMI { Wait($2) }
  | EXIT SEMI	{ Exit }
  | LBRACE stmt_list RBRACE { Block(List.rev $2) }
  | IF LPAREN expr RPAREN stmt %prec NOELSE { If($3, $5, Block([])) }
  | IF LPAREN expr RPAREN stmt ELSE stmt    { If($3, $5, $7) }
  | WHILE LPAREN expr RPAREN stmt { While($3, $5) }
  | BUY SYMBOL LITERAL SEMI { Buy($2, $3) }
  | SELL SYMBOL LITERAL SEMI { Sell($2, $3) }
  | LOOKUP SYMBOL cmpr SEMI { Lookup($2, $3) }
  | PRINT TEXT SEMI { Print($2) }

expr:
    LITERAL          { Literal($1) }
  | FLOAT	     { Price($1) }
  | ID               { Id($1) }
  | TRUE	     { True }
  | FALSE	     { False }
  | SYMBOL IS   cmpr { Symbol($1, $3) }
  | expr PLUS   expr { Binop($1, Add,   $3) }
  | expr MINUS  expr { Binop($1, Sub,   $3) }
  | expr TIMES  expr { Binop($1, Mult,  $3) }
  | expr DIVIDE expr { Binop($1, Div,   $3) }
  | expr EQ     expr { Binop($1, Equal, $3) }
  | expr NEQ    expr { Binop($1, Neq,   $3) }
  | expr LT     expr { Binop($1, Less,  $3) }
  | expr LEQ    expr { Binop($1, Leq,   $3) }
  | expr GT     expr { Binop($1, Greater,  $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3) }
  | expr AND	expr { Binop($1, And,   $3) }
  | expr OR	expr { Binop($1, Or,    $3) }
  | expr NOT	expr { Binop($1, Not,   $3) }
  | ID ASSIGN expr   { Assign($1, $3) }
  | LPAREN expr RPAREN { $2 }

