type op = Add | Sub | Mult | Div | Equal | Neq | Less | Leq | Greater | Geq | And | Or | Not

type expr =
    Literal of int
  | Price of float
  | Symbol of string * string
  | Id of string
  | Binop of expr * op * expr
  | Assign of string * expr
  | True
  | False
  | Noexpr

type stmt =
    Block of stmt list
  | Expr of expr
  | Return
  | Wait of int
  | Waitexe of stmt
  | Exit
  | If of expr * stmt * stmt
  | While of expr * stmt
  | Buy of string * int
  | Sell of string * int
  | Lookup of string * string
  | Print of string
  
type func_decl = {
    fname : string;
    locals : string list;
    body : stmt list;
  }

type program = string list * func_decl list
