{ open Parser }

rule token = parse
  [' ' '\t' '\r' '\n'] { token lexbuf }
| "/*"                 { comment lexbuf }

| ";"                  { SEMICOLON }
| ","                  { COMMA }

| "("                  { LEFT_PAREN }
| ")"                  { RIGHT_PAREN }
| "{"                  { LEFT_BRACE }
| "}"                  { RIGHT_BRACE }
| "["                  { LEFT_BRACKET }
| "]"                  { RIGHT_BRACKET }

| "+"                  { PLUS }
| "-"                  { MINUS }
| "*"                  { TIMES }
| "/"                  { DIVIDE }
| "="                  { ASSIGN }

| "=="                 { EQUAL }
| "!="                 { NOT_EQUAL }
| "<"                  { LESS_THAN }
| ">"                  { GREATER_THAN }
| "<="                 { LESS_EQUAL }
| ">="                 { GREATER_EQUAL }

| "if"                 { IF }
| "else"               { ELSE }
| "while"              { WHILE }

| "int"                { INT }

| "return"             { RETURN }

| eof                  { EOF }

| '-'?['0'-'9']+ as lit    { LITERAL(int_of_string lit) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lit  { ID(lit) }

| _ as char     { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  "*/"         { token lexbuf }
| _            { comment lexbuf }

and line_comment = parse
  ['\r' '\n']  { token lexbuf }
| _            { comment lexbuf }
