#!/bin/bash
files="tests/check/*.str"

for test in $files
do
	echo $test
	./strlang -c $test >& tmp.out
	 diff -b $test.out tmp.out || {
		echo "FAILED"
		exit 1
	}
done


echo "line" >& tmp.txt

files="tests/run/*.str"

for test in $files
do
	echo $test
	./strlang -e $test tmp >& tmp.build
	./tmp >& tmp.out
	diff -b $test.out tmp.out || {
		echo "FAILED"
		exit 1
	}
done

echo "SUCCEEDED"
rm -f tmp.out tmp_strlang.cpp tmp.build tmp.txt tmp
