/*
** wrappers used by strlang for manipulating string and map data-types
** implementations for builtin functions
*/

#ifndef __strlib_h
#define __strlib_h

#include <cstdio>
#include <string>
#include <map>
#include <pcrecpp.h>

using namespace std;

FILE *__in = stdin;
FILE *__out = stdout;

void write(const string &s) { fprintf(__out, "%s", s.c_str()); }

string read(void)
{
	char buffer[512];
	int len;
	
	fgets(buffer, 512, __in);
	len = strlen(buffer);
	
	if(buffer[len - 1] == '\n') buffer[len - 1] = '\0';
	
	else fprintf(stderr, "library error: read\n");

	return string(buffer);
}

int end_input(void) { return (__in == stdin) ? 0 : feof(__in); }

string to_string(const int n)
{
	char buf[20];
	sprintf(buf, "%d", n);
	return string(buf);
}

int to_num(const string &s)
{
	char *end;
	int i = strtol(s.c_str(), &end, 10);
	
	if(*end) fprintf(stderr, "library error: to_int\n");
	
	return i;
}

void open(const string &inout, const string &file)
{
	if(strcmp(inout.c_str(), "in") == 0)
	{
		if(__in != stdin) fclose(__in);
		
		if(file == "stdin") __in = stdin;
		
		else if(!(__in = fopen(file.c_str(), "r")))
		{
			fprintf(stderr, "library error: open(\"in\", %s)\n", file.c_str());
			__in = stdin;
		}
	}
	
	else if(strcmp(inout.c_str(), "out") == 0)
	{
		if(__out != stderr && __out != stdout) fclose(__out);
		
		if(file == "stdout") __out = stdout;
		
		else if(!(__out = fopen(file.c_str(), "a")))
		{
			fprintf(stderr, "library error: open(\"out\", %s)\n", file.c_str());
			__out = stdout;
		}
	}
	
	else fprintf(stderr, "library error: invalid argument to open: %s\n", inout.c_str());
}

int __str_len(const string &s)
{
	return s.size();
}

string __str_substr(const string &s, const int i)
{
	if(i >= 0) return s.substr(i);
	else return s.substr(0, -i);
}

string __str_replace(const string orig, const string &search, const string &replace)
{
	string out(orig);
	pcrecpp::RE(search).GlobalReplace(replace, &out);
	return out;
}

string __str_match(const string orig, const string &search)
{
	string out;
	pcrecpp::RE("(" + search + ")").PartialMatch(orig, &out);
	return out;
}

int __str_index(const string &orig, string &search)
{
	string tmp = __str_match(orig, search);
	return ((tmp != "") ? orig.find(tmp) : -1);
}

int __str_less(const string &l, const string &r) { return (l < r) ? 1 : 0; }
int __str_greater(const string &l, const string &r) { return (l > r) ? 1 : 0; }
int __str_lessequal(const string &l, const string &r) { return (l <= r) ? 1 : 0; }
int __str_greaterequal(const string &l, const string &r) { return (l >= r) ? 1 : 0; }
int __str_equal(const string &l, const string &r) { return (l == r) ? 1 : 0; }
int __str_notequal(const string &l, const string &r) { return (l != r) ? 1 : 0; }

template <class key, class val>
map<key, val> __map_empty(map<key, val> &m) { m.clear(); return m; }

template <class key, class val>
int __map_equal(const map<key, val> &l, const map<key, val> &r) { return (l == r) ? 1 : 0; }

template <class key, class val>
int __map_notequal(const map<key, val> &l, const map<key, val> &r) { return (l != r) ? 1 : 0; }

string __str_concat(const string &l, string &r) { return l + r; }

template <class key, class val>
val __map_remove(map<key, val> &m, const key &k) { val v = m[k]; m.erase(k); return v; }

template <class key, class val>
int __map_exists(map<key, val> &m, const key &k)
{
	typename map<key, val>::iterator it = m.find(k);
	return (it != m.end());
}

template <class key, class val>
map<int, key> __map_keys(map<key, val> &m)
{
	int i = 0;
	map<int, key> k;
	for(typename map<key, val>::const_iterator it = m.begin(); it != m.end(); ++it)
	{
		k[i] = it->first;
		i++;
	}
	return k;
}

template <class key, class val>
map<int, val> __map_vals(map<key, val> &m)
{
	int i = 0;
	map<int, val> v;
	for(typename map<key, val>::const_iterator it = m.begin(); it != m.end(); ++it)
	{
		v[i] = it->second;
		i++;
	}
	return v;
}

template <class key, class val>
int __map_len(const map<key, val> &m)
{
	return m.size();
}

#endif
