(* tokenize input *)

{ open Parser }

rule token = parse
[' ' '\t' '\r' '\n'] { token lexbuf }
| "//"	{ comment lexbuf }
| '('	 { LPAREN }		| ')'	 { RPAREN }	
| '{'	 { LBRACE }		| '}'	 { RBRACE }
| '['	 { LBRACKET }	| ']'	 { RBRACKET }

| '+'	 { PLUS }		| '-'	 { MINUS }
| '*'	 { TIMES }		| '/'	 { DIVIDE }
| '%'	{ MOD }

| '|'	 { OR }			| '&'	{ AND }

| '<'	{ LESS }		| '>'	{ GREATER }
| "<="	{ LESSEQUAL }	| ">="	{ GREATEREQUAL }
| "=="	{ EQUAL }		| "!="	{ UNEQUAL }

| '!'	{ NOT }			| '^'	{ CARET }
| '~'	{ TILDE }		| '@'	{ AT}

| "<-"	{ LARROW }		| "->"	{ RARROW }
| eof	{ EOF }

| '#'	{ NUM }			| '$'	{ STR }

| ';'	{ SEMI }

| ['0'-'9']+ as lxm { NUM_LITERAL(int_of_string lxm) }
| '\"'[^'\"']*'\"' as lxm { STR_LITERAL(lxm) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }

| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
 "\n" { token lexbuf }
| _	{ comment lexbuf }