
/* GENERATED HEADER C */

#ifndef CLAM_H
#define CLAM_H
/*
 * CLAM C Interface Header
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <float.h>
#include <limits.h>
#include <math.h>

#define __STDC_LIMIT_MACROS
#include <stdint.h>


/* --- --- --- --- --- --- --- */
/* stolen from: linux/list.h   */
/* --- --- --- --- --- --- --- */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _DEBUG
#define DBG(X) X
#else
#define DBG(X)
#endif

struct list_head {
	struct list_head *next, *prev;
};

static inline void INIT_LIST_HEAD(struct list_head *nm)
{
	nm->next = nm;
	nm->prev = nm;
}

static inline void __list_add(struct list_head *newI,
			      struct list_head *prev,
			      struct list_head *next) {
	next->prev = newI;
	newI->next = next;
	newI->prev = prev;
	prev->next = newI;
}

static inline void list_add(struct list_head *newI, struct list_head *head)
{
	__list_add(newI, head, head->next);
}

static inline void list_add_tail(struct list_head *newI, struct list_head *head)
{
	__list_add(newI, head->prev, head);
}

#define __list_del(__prev, __next) \
	(__next)->prev = __prev; \
	(__prev)->next = __next

static inline void list_del(struct list_head *entry)
{
	__list_del(entry->prev, entry->next);
}

static inline void list_del_init(struct list_head *entry)
{
	__list_del(entry->prev, entry->next);
	INIT_LIST_HEAD(entry);
}

static inline void list_move(struct list_head *list, struct list_head *head)
{
	__list_del(list->prev, list->next);
	list_add(list, head);
}

static inline void list_move_tail(struct list_head *list,
				  struct list_head *head)
{
	__list_del(list->prev, list->next);
	list_add_tail(list, head);
}

static inline int list_is_last(const struct list_head *list,
				const struct list_head *head)
{
	return list->next == head;
}

static inline int list_empty(const struct list_head *head)
{
	return head->next == head;
}

#ifndef offsetof
#define offsetof(st, m) \
     ((size_t) ( (char *)&((st *)(0))->m - (char *)0 ))
#endif

#define container_of(ptr, type, member) ({			\
	const typeof( ((type *)0)->member ) *__mptr = (ptr);	\
	(type *)( (char *)__mptr - offsetof(type,member) );})

#define list_entry(ptr, type, member) \
	container_of(ptr, type, member)

#define list_first_entry(ptr, type, member) \
	list_entry((ptr)->next, type, member)

#define list_for_each(pos, head) \
	for (pos = (head)->next; pos != (head); pos = pos->next)

#define list_for_each_prev(pos, head) \
	for (pos = (head)->prev; pos != (head); pos = pos->prev)

#define list_for_each_safe(pos, n, head) \
	for (pos = (head)->next, n = pos->next; pos != (head); \
		pos = n, n = pos->next)

#define list_for_each_prev_safe(pos, n, head) \
	for (pos = (head)->prev, n = pos->prev; \
	     pos != (head); \
	     pos = n, n = pos->prev)

#define list_for_each_entry(pos, head, member)				\
	for (pos = list_entry((head)->next, typeof(*pos), member);	\
	     &pos->member != (head); 	\
	     pos = list_entry(pos->member.next, typeof(*pos), member))

#define list_for_each_entry_reverse(pos, head, member)			\
	for (pos = list_entry((head)->prev, typeof(*pos), member);	\
	     &pos->member != (head); 	\
	     pos = list_entry(pos->member.prev, typeof(*pos), member))


/* --- --- --- --- --- --- --- */
/* CLAM type declarations      */
/* --- --- --- --- --- --- --- */

typedef enum clam_img_fmt_e {
	PNG = 0,
	BMP,
	TGA,
	JPG,
	CLAM_NUMFMTS,
} clam_img_fmt;


typedef enum clam_atom_e {
	UINT8 = 0,
	UINT16,
	UINT32,
	INT8,
	INT16,
	INT32,
	ANGLE,
	CLAM_NUMTYPES,
} clam_atom;

#define clam_type_union \
	uint8_t  u8;  \
	uint16_t u16; \
	uint32_t u32; \
	int8_t   s8;  \
	int16_t  s16; \
	int32_t  s32; \
	float    f32;

static inline int clam_atom_sz(clam_atom a) {
	switch (a) {
	case UINT8:
		return sizeof(uint8_t);
	case UINT16:
		return sizeof(uint16_t);
	case UINT32:
		return sizeof(uint32_t);
	case INT8:
		return sizeof(int8_t);
	case INT16:
		return sizeof(int16_t);
	case INT32:
		return sizeof(int32_t);
	case ANGLE:
		return sizeof(float);
	default:
		return 0;
	}
}

/* ImageT */
typedef struct clam_img {
	unsigned char *p;
	int width;
	int height;
	struct list_head chan;   /* master channel list */
	int num_chan;            /* total number of channels */
	unsigned char **curr_p;  /* channel data pointers: dynamically setup */
	unsigned int   *curr_s;
	const char *name;
} clam_img;

/* clam matrix (for kernel computation) */
typedef struct clam_matrix {
	int32_t rows, cols;
	union { clam_type_union } num;
	union { clam_type_union } denom;
	void *d;
} clam_matrix;

#define clam_calc_setmatrix(_calc, _type, _rows, _cols, _num, _denom, _data...) \
	(_calc)->ismat = 1; \
	(_calc)->m.rows = _rows; \
	(_calc)->m.cols = _cols; \
	*((_type *)(&(_calc)->m.num)) = _num; \
	*((_type *)(&(_calc)->m.denom)) = _denom; \
	static int _calc ## _matdata [_rows][_cols] = _data; \
	(_calc)->m.d = & _calc ## _matdata

/* CalcT */
typedef struct clam_calc {
	const char  *name;
	clam_atom    type;
	int          ismat;
	clam_matrix  m;
} clam_calc;

/* elements of a KernelT */
typedef struct clam_kcalc {
	struct list_head list;
	int used;
	clam_calc *calc;
} clam_kcalc;

/* KernelT */
typedef struct clam_kernel {
	struct list_head allcalc;
} clam_kernel;

/* ImageT channels */
typedef struct clam_imgchan {
	struct list_head  list;
	clam_img         *img;
	const char       *name;
	unsigned char    *p;
	clam_atom         type;
	uint32_t          stride;
} clam_imgchan;


/* --- --- --- --- --- --- --- */
/* internal (compiler) API     */
/* --- --- --- --- --- --- --- */

#define bail(msg, ...) \
{ \
	fprintf(stderr, "CLAM Runtime ERROR: " msg "\n", ## __VA_ARGS__ ); \
	exit(EXIT_FAILURE); \
}

#define clam_alloc_check(var) \
	if (!var) bail("out of memory for " #var)

static inline clam_img *clam_img_alloc(void)
{
	clam_img *img;
	img = (clam_img *)malloc(sizeof(*img));
	if (!img)
		return NULL;
	/* simple init */
	memset(img, 0, sizeof(*img));
	img->width = img->height = -1;
	img->num_chan = 0;
	INIT_LIST_HEAD(&img->chan);

	return img;
}

static inline void clam_img_free(clam_img *img)
{
	struct list_head *pos, *tmp;
	clam_imgchan *ch;

	if (!img) return;
	list_for_each_safe(pos, tmp, &img->chan) {
		ch = list_entry(pos, typeof(*ch), list);
		list_del(pos);
		free(ch->p);
		free(ch);
	}
	free(img->curr_p);
	free(img->curr_s);
	free(img->p);
	free(img);
}

static inline int clam_img_valid(clam_img *img)
{
	return (img->width > 0) && (img->height > 0);
}

static inline void clam_img_setup_calc(clam_img *img)
{
	clam_imgchan *ch;
	int i;

	free(img->curr_p); /* kill previous setup */
	free(img->curr_s);
	img->curr_p = (unsigned char **)malloc(img->num_chan * sizeof(char *));
	img->curr_s = (unsigned int *)malloc(img->num_chan * sizeof(int));
	if (!img->curr_p || !img->curr_s) {
		fprintf(stderr, "Internal memory alloc error\n");
		return;
	}

	i = 0;
	list_for_each_entry(ch, &img->chan, list) {
		img->curr_p[i] = ch->p;
		img->curr_s[i] = ch->stride;
		i++;
	}
}

#define clam_img_next_pix(img) \
	{ int __chidx__; \
	for (__chidx__ = 0; __chidx__ < img->num_chan; __chidx__++) { \
		img->curr_p[__chidx__] += img->curr_s[__chidx__]; \
	} \
	}

#define clam_img_pix(type, chidx) \
	(*((type *)((pp)[chidx])))

static inline clam_calc *clam_calc_alloc(const char *name, clam_atom type)
{
	clam_calc *c;
	c = (clam_calc *)malloc(sizeof(*c));
	clam_alloc_check(c);
	memset(c, 0, sizeof(*c));
	c->name = name;
	c->type = type;
	return c;
}

static inline clam_kernel *clam_kernel_alloc(void)
{
	clam_kernel *k;
	k = (clam_kernel *)malloc(sizeof(*k));
	clam_alloc_check(k);
	memset(k, 0, sizeof(*k));
	INIT_LIST_HEAD(&k->allcalc);
	return k;
}

static inline void clam_kernel_free(clam_kernel *kern)
{
	struct list_head *pos, *tmp;
	clam_kcalc *kc;
	if (!kern) return;

	list_for_each_safe(pos, tmp, &kern->allcalc) {
		kc = list_entry(pos, typeof(*kc), list);
		list_del(pos);
		free(kc);
	}

	free(kern);
}

#define TEMP_clam_kernel_addcalc(K,C) \
	clam_kernel_addcalc(K, C, 1)

static clam_kernel *clam_kernel_addcalc(clam_kernel *kern, clam_calc *calc, int used)
{
	clam_kcalc *kc;
	kc = (clam_kcalc *)malloc(sizeof(*kc));
	if (!kc) {
		fprintf(stderr, "out of memory\n");
		return NULL;
	}
	memset(kc, 0, sizeof(*kc));
DBG(	printf("Adding %s to kernel\n", calc->name);)
	INIT_LIST_HEAD(&kc->list);
	kc->calc = calc;
	kc->used = used;
	list_add(&kc->list, &kern->allcalc);

	return kern;
}

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                                                                 */
/* CLAM heavy lifting functions                                    */
/* (implemented in generated C file)                               */
/*                                                                 */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */

extern clam_img *clam_img_copy(clam_img *src);

#define clam_img_assign(DST, SRC) \
	({ if (DST) clam_img_free(DST); DST = (SRC); })


extern clam_kernel *clam_kernel_copy(clam_kernel *src);

#define clam_kernel_assign(DST, SRC) \
	({ if (DST) clam_kernel_free(DST); DST = (SRC); })

extern clam_img *__clam_imgchan_add(clam_img *img, clam_atom type,
				    const char *name, int should_alloc);

#define clam_imgchan_addcalc(IMG, CHAN) \
	__clam_imgchan_add(IMG, (CHAN)->type, #CHAN, 0)

#define clam_imgchan_add_empty(IMG, NAME, TYPE) \
	__clam_imgchan_add(IMG, TYPE, #NAME, 1)

extern void clam_imgchan_del(clam_img *img, const char *name);

extern clam_imgchan *clam_imgchan_ref(clam_img *img, const char *name);

#define clam_imgchan_copy(DST, DNAME, SCHAN) \
	({if (!DST) DST = clam_img_alloc(); \
	__clam_imgchan_copy(DST, DNAME, SCHAN); })

extern clam_imgchan *__clam_imgchan_copy(clam_img *dst, const char *dname,
					 clam_imgchan *schan);

extern void clam_img_resize(clam_img *img, int width, int height);

/* Functional Library Interface */
extern clam_img *imgread(const char *filename);
extern int imgwrite(clam_img *img, clam_img_fmt fmt, const char *filename);

#ifdef __cplusplus
} /* extern "C" */

extern void clam_convolve_matrix(clam_img *outimg,
				 clam_imgchan *ch,
				 clam_calc *calc);

/* Convolution (much easier with templates) */
template<typename CalcT, typename ChanT>
void __clam_convolve_matrix(clam_img *outimg, clam_imgchan *ch, clam_calc *calc, int min, int max)
{
	int xx, xstart, xend;
	int yy, ystart, yend;
	int kx, kxstart, kxend;
	int ky, kystart, kyend;
	int k_start, k_stride;
	int width, height;
	clam_imgchan *outchan;
	CalcT *dpix;
	ChanT *spix;

	int *kern, num, denom;

	if (!calc->ismat)
		return;

	if (!clam_img_valid(outimg))
		clam_img_resize(outimg, ch->img->width, ch->img->height);

	/* add the channel to the image
	 * (if it's unused, we'll remove it later)
	 */
	__clam_imgchan_add(outimg, calc->type, calc->name, 1);
	outchan = clam_imgchan_ref(outimg, calc->name);

	width = outimg->width;
	height = outimg->height;

	kern = (int *)(calc->m.d);
	num = (int)*((CalcT *)&(calc->m.num));
	denom = (int)*((CalcT *)&(calc->m.denom));

DBG(	printf("\tConvolve[%d/%d]: %s:%s = %s ** %s\n", num,denom, outimg->name, calc->name, ch->name, calc->name);)
	/* XXX: remove this when we add boundary support! */
	memset(outchan->p, 0, width * height * sizeof(CalcT));

	/* XXX: do first N rows */

	ystart = calc->m.rows/2 + 1;
	yend = height - calc->m.rows;
	xstart = calc->m.cols/2 + 1;
	xend = width - calc->m.cols;

	kystart = -(calc->m.rows/2);
	kyend = kystart + calc->m.rows;
	kxstart = -(calc->m.cols/2);
	kxend = kxstart + calc->m.cols;

	k_start = kystart*width + kxstart;
	k_stride = width - calc->m.cols;

	for (yy = ystart; yy < yend; yy++) {
		/* XXX: do first N cols */

		dpix = &( ((CalcT *)outchan->p)[(yy * width) + xstart] );
		spix = &( ((ChanT *)ch->p)[(yy * width) + xstart]);
		for (xx = xstart; xx < xend; xx++, dpix++, spix++) {
			/* kernel operation */
			int kidx = 0;
			int sidx = k_start;
			int val = 0;
			for (ky = kystart; ky < kyend; ky++, sidx += k_stride) {
				for (kx = kxstart; kx < kxend; kx++, kidx++, sidx++) {
					val += (int)(spix[sidx]) * kern[kidx];
				}
			}
			val *= num;
			val /= denom;
			/* clamp */
			val = (val < min ? min : (val > max ? max : val));
			*dpix = (CalcT)(val);
		}

		/* XXX: do last N cols */
	}

	/* XXX: do last N rows */
}

/* XXX: create a partially specialized function for float... ?! */
#endif

#endif /* CLAM_H */
/*
 * Template C file for CLAM backend
 * Jeremy C. Andrus <jeremya@cs.columbia.edu>
 * 2011-12-12
 */

/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */
/*                                                                 */
/* CLAM heavy lifting functions                                    */
/*                                                                 */
/* --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- */

clam_img *clam_img_copy(clam_img *src)
{
	bail("image copy not quite supported... check back later");
}

clam_kernel *clam_kernel_copy(clam_kernel *src)
{
	bail("kernel copy not quite supported... check back later");
}

clam_img *__clam_imgchan_add(clam_img *img, clam_atom type,
			     const char *name, int should_alloc)
{
	clam_imgchan *chan;

DBG(	printf("Adding %s to %s\n", name, img->name);)
	chan = (clam_imgchan *)malloc(sizeof(*chan));
	if (!chan)
		bail("no memory for channel");

	INIT_LIST_HEAD(&chan->list);
	chan->name = name;
	chan->img = img;
	chan->type = type;
	chan->stride = clam_atom_sz(type);
	if (should_alloc) {
		int sz = img->width * img->height * chan->stride;
		chan->p = (unsigned char *)malloc(sz);
		if (!chan->p)
			bail("no memory for channel");
	} else
		chan->p = NULL;

	list_add_tail(&chan->list, &img->chan);
	img->num_chan++;
	return img;
}

void clam_imgchan_del(clam_img *img, const char *name)
{
DBG(	printf("Removing %s from %s\n", name, img->name);)
	clam_imgchan *ch = clam_imgchan_ref(img, name);
	list_del(&ch->list);
	free(ch->p);
	free(ch);
}

int clam_imgchan_exists(clam_img *img, const char *name)
{
	clam_imgchan *ch;
	list_for_each_entry(ch, &img->chan, list) {
		if (strcmp(name, ch->name) == 0)
			return 1;
	}
	return 0;
}


clam_imgchan *clam_imgchan_ref(clam_img *img, const char *name)
{
	clam_imgchan *ch;
	list_for_each_entry(ch, &img->chan, list) {
		if (strcmp(name, ch->name) == 0) {
			goto out;
		}
	}
	bail("Invalid channel: %s", name);
out:
	return ch;
}

#define clam_imgchan_eval(__img, __type, __ch) \
{ \
	int pix, sz; \
	unsigned char *chan_ptr; \
	unsigned char **pp; \
	__type *val; \
	if (!((__ch)->p)) { \
		sz = (__img)->width * (__img)->height; \
		val = (__type *)malloc(sz * (__ch)->stride); \
		clam_alloc_check(val); \
		(__ch)->p = (unsigned char *)val; \
		clam_img_setup_calc(__img); \
		for (pix = 0; pix < sz; ++pix) { \
			pp = (__img)->curr_p; \
			*val++ = (__type)( cfunc ); \
			clam_img_next_pix(__img); \
		} \
	} \
}


clam_imgchan *__clam_imgchan_copy(clam_img *dst, const char *dname,
				clam_imgchan *schan)
{
	int sz;
	clam_imgchan *dchan;
	clam_img *src = schan->img;

DBG(	printf("Copy-> %s:%s = %s:%s\n",dst->name,dname,schan->img->name,schan->name);)
	if (!clam_img_valid(dst))
		clam_img_resize(dst, src->width, src->height);

	if (dst->width != src->width || dst->height != src->height) {
		bail("incompatible images in chan copy (%s->%s)", schan->name, dname);
	}

	if (clam_imgchan_exists(dst, dname))
		clam_imgchan_del(dst, dname);

	__clam_imgchan_add(dst, schan->type, dname, 1);
	dchan = clam_imgchan_ref(dst, dname);

	sz = src->width * src->height * schan->stride;
	memcpy(dchan->p, schan->p, sz);
}

void clam_img_resize(clam_img *img, int width, int height)
{
	if (!list_empty(&img->chan))
		bail("Can't resize an image with existing channels!");

	img->width = width;
	img->height = height;
	img->num_chan = 0;
	free(img->curr_p); img->curr_p = NULL;
	free(img->curr_s); img->curr_s = NULL;
}

void clam_convolve_matrix(clam_img *outimg,
			  clam_imgchan *ch,
			  clam_calc *calc)
{
	/* switch on destination type (CalcT) */
	switch (calc->type) {
	case UINT8:
		/* switch on source type (ChanT) */
		switch (ch->type) {
		case UINT8:
			__clam_convolve_matrix<uint8_t, uint8_t>(outimg, ch, calc, 0, UINT8_MAX);
			break;
		case UINT16:
			__clam_convolve_matrix<uint8_t, uint16_t>(outimg, ch, calc, 0, UINT8_MAX);
			break;
		case UINT32:
			__clam_convolve_matrix<uint8_t, uint32_t>(outimg, ch, calc, 0, UINT8_MAX);
			break;
		case INT8:
			__clam_convolve_matrix<uint8_t, int8_t>(outimg, ch, calc, 0, UINT8_MAX);
			break;
		case INT16:
			__clam_convolve_matrix<uint8_t, int16_t>(outimg, ch, calc, 0, UINT8_MAX);
			break;
		case INT32:
			__clam_convolve_matrix<uint8_t, int32_t>(outimg, ch, calc, 0, UINT8_MAX);
			break;
		case ANGLE:
			__clam_convolve_matrix<uint8_t, float>(outimg, ch, calc, 0, UINT8_MAX);
			break;
		default:
			bail("invalid channel type?!");
		}
		break;
	case UINT16:
		switch (ch->type) {
		case UINT8:
			__clam_convolve_matrix<uint16_t, uint8_t>(outimg, ch, calc, 0, UINT16_MAX);
			break;
		case UINT16:
			__clam_convolve_matrix<uint16_t, uint16_t>(outimg, ch, calc, 0, UINT16_MAX);
			break;
		case UINT32:
			__clam_convolve_matrix<uint16_t, uint32_t>(outimg, ch, calc, 0, UINT16_MAX);
			break;
		case INT8:
			__clam_convolve_matrix<uint16_t, int8_t>(outimg, ch, calc, 0, UINT16_MAX);
			break;
		case INT16:
			__clam_convolve_matrix<uint16_t, int16_t>(outimg, ch, calc, 0, UINT16_MAX);
			break;
		case INT32:
			break;
			__clam_convolve_matrix<uint16_t, int32_t>(outimg, ch, calc, 0, UINT16_MAX);
		case ANGLE:
			break;
			__clam_convolve_matrix<uint16_t, float>(outimg, ch, calc, 0, UINT16_MAX);
		default:
			bail("invalid channel type?!");
		}
		break;
	case UINT32:
		switch (ch->type) {
		case UINT8:
			__clam_convolve_matrix<uint32_t, uint8_t>(outimg, ch, calc, 0, UINT32_MAX);
			break;
		case UINT16:
			__clam_convolve_matrix<uint32_t, uint16_t>(outimg, ch, calc, 0, UINT32_MAX);
			break;
		case UINT32:
			__clam_convolve_matrix<uint32_t, uint32_t>(outimg, ch, calc, 0, UINT32_MAX);
			break;
		case INT8:
			__clam_convolve_matrix<uint32_t, int8_t>(outimg, ch, calc, 0, UINT32_MAX);
			break;
		case INT16:
			__clam_convolve_matrix<uint32_t, int16_t>(outimg, ch, calc, 0, UINT32_MAX);
			break;
		case INT32:
			__clam_convolve_matrix<uint32_t, int32_t>(outimg, ch, calc, 0, UINT32_MAX);
			break;
		case ANGLE:
			__clam_convolve_matrix<uint32_t, float>(outimg, ch, calc, 0, UINT32_MAX);
			break;
		default:
			bail("invalid channel type?!");
		}
		break;
	case INT8:
		switch (ch->type) {
		case UINT8:
			__clam_convolve_matrix<int8_t, uint8_t>(outimg, ch, calc, INT8_MIN, INT8_MAX);
			break;
		case UINT16:
			__clam_convolve_matrix<int8_t, uint16_t>(outimg, ch, calc, INT8_MIN, INT8_MAX);
			break;
		case UINT32:
			__clam_convolve_matrix<int8_t, uint32_t>(outimg, ch, calc, INT8_MIN, INT8_MAX);
		case INT8:
			break;
			__clam_convolve_matrix<int8_t, int8_t>(outimg, ch, calc, INT8_MIN, INT8_MAX);
		case INT16:
			break;
			__clam_convolve_matrix<int8_t, int16_t>(outimg, ch, calc, INT8_MIN, INT8_MAX);
		case INT32:
			break;
			__clam_convolve_matrix<int8_t, int32_t>(outimg, ch, calc, INT8_MIN, INT8_MAX);
		case ANGLE:
			break;
			__clam_convolve_matrix<int8_t, float>(outimg, ch, calc, INT8_MIN, INT8_MAX);
		default:
			bail("invalid channel type?!");
		}
		break;
	case INT16:
		switch (ch->type) {
		case UINT8:
			__clam_convolve_matrix<int16_t, uint8_t>(outimg, ch, calc, INT16_MIN, INT16_MAX);
			break;
		case UINT16:
			__clam_convolve_matrix<int16_t, uint16_t>(outimg, ch, calc, INT16_MIN, INT16_MAX);
			break;
		case UINT32:
			__clam_convolve_matrix<int16_t, uint32_t>(outimg, ch, calc, INT16_MIN, INT16_MAX);
			break;
		case INT8:
			__clam_convolve_matrix<int16_t, int8_t>(outimg, ch, calc, INT16_MIN, INT16_MAX);
			break;
		case INT16:
			__clam_convolve_matrix<int16_t, int16_t>(outimg, ch, calc, INT16_MIN, INT16_MAX);
			break;
		case INT32:
			__clam_convolve_matrix<int16_t, int32_t>(outimg, ch, calc, INT16_MIN, INT16_MAX);
			break;
		case ANGLE:
			__clam_convolve_matrix<int16_t, float>(outimg, ch, calc, INT16_MIN, INT16_MAX);
			break;
		default:
			bail("invalid channel type?!");
		}
		break;
	case INT32:
		switch (ch->type) {
		case UINT8:
			__clam_convolve_matrix<int32_t, uint8_t>(outimg, ch, calc, INT32_MIN, INT32_MAX);
			break;
		case UINT16:
			__clam_convolve_matrix<int32_t, uint16_t>(outimg, ch, calc, INT32_MIN, INT32_MAX);
			break;
		case UINT32:
			__clam_convolve_matrix<int32_t, uint32_t>(outimg, ch, calc, INT32_MIN, INT32_MAX);
			break;
		case INT8:
			__clam_convolve_matrix<int32_t, int8_t>(outimg, ch, calc, INT32_MIN, INT32_MAX);
			break;
		case INT16:
			__clam_convolve_matrix<int32_t, int16_t>(outimg, ch, calc, INT32_MIN, INT32_MAX);
			break;
		case INT32:
			__clam_convolve_matrix<int32_t, int32_t>(outimg, ch, calc, INT32_MIN, INT32_MAX);
			break;
		case ANGLE:
			__clam_convolve_matrix<int32_t, float>(outimg, ch, calc, INT32_MIN, INT32_MAX);
			break;
		default:
			bail("invalid channel type?!");
		}
		break;
	case ANGLE:
		switch (ch->type) {
		case UINT8:
			__clam_convolve_matrix<float, uint8_t>(outimg, ch, calc, 0, INT32_MAX);
			break;
		case UINT16:
			__clam_convolve_matrix<float, uint16_t>(outimg, ch, calc, 0, INT32_MAX);
			break;
		case UINT32:
			__clam_convolve_matrix<float, uint32_t>(outimg, ch, calc, 0, INT32_MAX);
			break;
		case INT8:
			__clam_convolve_matrix<float, int8_t>(outimg, ch, calc, 0, INT32_MAX);
			break;
		case INT16:
			__clam_convolve_matrix<float, int16_t>(outimg, ch, calc, 0, INT32_MAX);
			break;
		case INT32:
			__clam_convolve_matrix<float, int32_t>(outimg, ch, calc, 0, INT32_MAX);
			break;
		case ANGLE:
			__clam_convolve_matrix<float, float>(outimg, ch, calc, 0, INT32_MAX);
			break;
		default:
			bail("invalid channel type?!");
		}
		break;
	default:
		bail("invalid calculation type?!");
	}
}


#define clam_convolve_cfunc(CALC,TYPE,CFUNC...) \
{ \
	clam_imgchan *__outchanref; \
	__clam_imgchan_add(__IMG, (CALC)->type, (CALC)->name, 0); \
	__outchanref = clam_imgchan_ref(__IMG, (CALC)->name); \
	clam_imgchan_eval(__IMG, TYPE, __outchanref); \
}

#define clam_convfunc_start(IDX,IMGNAME,CHANNAME) \
clam_img *__convolution ## IDX(clam_kernel *kern) { \
	clam_kcalc *__kc; \
	clam_img *__IMG; \
	clam_imgchan *__CONVCHAN = clam_imgchan_ref(IMGNAME, #CHANNAME); \
	__IMG = clam_img_alloc(); \
	list_for_each_entry_reverse(__kc, &kern->allcalc, list) { \
		clam_calc *__c = __kc->calc; \
		if (__c->ismat) { \
			clam_convolve_matrix(__IMG, __CONVCHAN, __c); \
		} else { \

#define clam_convfunc_chk(CHAN) \
			if (strcmp(__c->name, #CHAN) == 0) \
				goto do_ ## CHAN;

#define clam_convfunc_lastchk() \
			continue;

#define clam_convfunc_end(IDX) \
		} \
	} \
	clam_img_cleanup(__IMG, kern); \
	return __IMG; \
}

void clam_img_cleanup(clam_img *img, clam_kernel *kern)
{
	clam_kcalc *kc;
	list_for_each_entry(kc, &kern->allcalc, list) {
		if (!kc->used)
			clam_imgchan_del(img, kc->calc->name);
	}
}


/* GENERATED ENVIRONMENT C */
clam_img *__imgT_a = NULL;
clam_img *__imgT_outR = NULL;
clam_img *__imgT_outG = NULL;
clam_img *__imgT_outB = NULL;
clam_img *__imgT_out = NULL;
clam_kernel *__kernT_dogauss = NULL;
clam_calc *__calcT_grey = NULL;
clam_calc *__calcT_dummy = NULL;
clam_calc *__calcT_gauss = NULL;

clam_convfunc_start(2,__imgT_a,Blue)
		clam_convfunc_lastchk()
clam_convfunc_end(2)
clam_convfunc_start(1,__imgT_a,Green)
		clam_convfunc_lastchk()
clam_convfunc_end(1)
clam_convfunc_start(0,__imgT_a,Red)
		clam_convfunc_lastchk()
clam_convfunc_end(0)
/* GENERATED MAIN C */
int main(int argc, char **argv) {
  if (argc <= 2) {
    fprintf(stderr, "This program requires 2 arguments.\n");
    exit(1);
  }
  clam_img_assign(__imgT_a, imgread(argv[1]));
  __calcT_grey = clam_calc_alloc("grey", UINT8);
  __calcT_dummy = clam_calc_alloc("dummy", UINT8);
  clam_calc_setmatrix(__calcT_dummy, uint8_t, 1, 1, 1, 1, { {1} });
  __calcT_gauss = clam_calc_alloc("gauss", UINT8);
  clam_calc_setmatrix(__calcT_gauss, uint8_t, 5, 5, 1, 159, { {2, 4, 5, 4, 2}, {4, 9, 12, 9, 4}, {5, 12, 15, 12, 5}, {4, 9, 12, 9, 4}, {2, 4, 5, 4, 2} });
  ({ {
		clam_img *__IMG = __imgT_a;
		#define Blue  clam_img_pix(uint8_t,2)
		#define Green  clam_img_pix(uint8_t,1)
		#define Red  clam_img_pix(uint8_t,0)
		#define cfunc ((3*Red+6*Green+1*Blue)/10)
		clam_convolve_cfunc(__calcT_grey,uint8_t,cfunc)
		#undef cfunc
		#undef Blue
		#undef Green
		#undef Red

	}; __imgT_a; });
  clam_kernel_assign(__kernT_dogauss, (clam_kernel_addcalc(clam_kernel_addcalc(clam_kernel_alloc(),__calcT_dummy,0),__calcT_gauss,1)) );
  clam_img_assign(__imgT_outR, __convolution0(__kernT_dogauss));
  clam_img_assign(__imgT_outG, __convolution1(__kernT_dogauss));
  clam_img_assign(__imgT_outB, __convolution2(__kernT_dogauss));
  /* DEBUG: Declare Image */;
  clam_imgchan_copy( __imgT_out, "Red", clam_imgchan_ref( __imgT_outR, "gauss"));
  clam_imgchan_copy( __imgT_out, "Green", clam_imgchan_ref( __imgT_outG, "gauss"));
  clam_imgchan_copy( __imgT_out, "Blue", clam_imgchan_ref( __imgT_outB, "gauss"));
  imgwrite( (__imgT_out) , PNG , argv[2] );

  return 0;
}
