(* Writtent by Zachary Salzbank, Erica Sponsler and Nate Weiss *)

{ open Parser }

let char_regex = [^ '\\' '\'']
let id = ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']*

rule token = parse
  [' ' '\t' '\r' '\n']            { token lexbuf } (* Whitespace *)
| "/*"                            { comment lexbuf }           (* Comments *)
| '('                             { LPAREN }
| ')'                             { RPAREN }
| '{'                             { LBRACE }
| '}'                             { RBRACE }
| '['                             { LBRACKET }
| ']'                             { RBRACKET }
| ';'                             { SEMI }
| ','                             { COMMA }
| '+'                             { PLUS }
| '-'                             { MINUS }
| '*'                             { TIMES }
| '/'                             { DIVIDE }
| '='                             { ASSIGN }
| '!'                             { BANG }
| "&&"                            { BOOLAND }
| "||"                            { BOOLOR }
| "=="                            { EQ }
| "!="                            { NEQ }
| '<'                             { LT }
| "<="                            { LEQ }
| ">"                             { GT }
| ">="                            { GEQ }
| "if"                            { IF }
| "else"                          { ELSE }
| "while"                         { WHILE }
| "break"                         { BREAK }
| "return"                        { RETURN }
| "int"                           { INT }
| "char"                          { CHAR }
| "boolean"                       { BOOLEAN }
| "Node"                          { NODE }
| ".value"                        { VALUEOF }
| "void"                          { VOID }
| "true"                          { BOOLEAN_LITERAL(true) }
| "false"                         { BOOLEAN_LITERAL(false) }
| "null"                          { NULL_LITERAL }
| "'\\''"                         { CHAR_LITERAL('\'') }
| "'\\\\'"                        { CHAR_LITERAL('\\') }
| "'" (char_regex as c) "'"       { CHAR_LITERAL(c) }
| ['0'-'9']+ as lxm               { INTEGER_LITERAL(int_of_string lxm) }
| id as lxm                       { ID(lxm) }
| eof                             { EOF }
| _ as char                       { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  "*/" { token lexbuf }
| _    { comment lexbuf }


  
