#!/bin/sh

agrajag="./agrajag"

Usage() {
    echo "Usage: make-output"
    exit 1
}
# Run <args>
# Report the command, run it, and report any errors
Run() {
    echo $* 1>&2
    eval $* || {
	echo "Failed on $1"
	return 1
    }
}

Check() {
    basename=`echo $1 | sed 's/.*\\///
                             s/.ag//'`
    Run "$agrajag" "-b" "<" $1 ">" tests/${basename}.bytecode.out
}

    files="tests/*.ag"

for file in $files
do
    case $file in
	*)
	    Check $file
    esac
done

exit
