type action = Ast | Interpret | Semantics | Bytecode | Compile

let _ =
  let action = if Array.length Sys.argv > 1 then
    List.assoc Sys.argv.(1) [ ("-a", Ast);
			      ("-i", Interpret);
                              ("-s", Semantics);
			      ("-b", Bytecode); 
			      ("-c", Compile); ]
  else Compile in
  let lexbuf = Lexing.from_channel stdin in
  let program = Parser.program Scanner.token lexbuf in
  let semantic_prog = Semantics.translate program in
  match action with
    Ast -> let listing = Ast.string_of_program program
           in print_string listing
  | Semantics -> print_endline (Sast.string_of_sast semantic_prog)
  | Interpret -> ignore (Interpret.run semantic_prog)
  | Bytecode -> let listing =
      Bytecode.string_of_prog (Compile.translate semantic_prog)
    in print_endline listing
  | Compile -> Execute.execute_prog (Compile.translate semantic_prog)
