#!/bin/bash
# Test program output is stored in {testCase}.generated
# The diff between program output and expected output is stored in {testCase}.diff

CSSLANG="./csslang"
TESTDIR="tests"
files=`ls $TESTDIR/test-*.in`

for file in $files
do
    basename=`basename $file`;
    basename=`echo $basename | sed 's/.in$//'`
    echo "#######  Testing $basename";
    $CSSLANG < $file > $TESTDIR/${basename}.generated;
    if diff -b $TESTDIR/${basename}.out $TESTDIR/${basename}.generated > $TESTDIR/${basename}.diff; then
        rm $TESTDIR/${basename}.diff $TESTDIR/${basename}.generated;
        echo "PASS";
    else
        echo "FAIL";
    fi
    echo;

done

