%{ 
    (* This is the file that specifies the gramma and the semantic actions to create the AST *)
    open Ast
    open Printf
    open List
    let list2str s e = s ^ e;;
    let list2str2 s e = 
        match s with
            ""  -> e
            | _   -> s ^ " " ^ e 
    let list2str3 s e =
        match s with
            "" -> e
            | _ -> s ^ ", " ^ e
%}

%token SEMI LBRACE RBRACE COMMA SPACE DOLLAR ATRULE
%token <string> PLUS MINUS TIMES DIVIDE
/* %token ATIMPORT ATCHARSET ATPAGE ATMEDIA */
%token EQ NEQ LT LEQ GT GEQ
/* %token RETURN IF ELSE FOR WHILE INT */
%token <string> NUMBER
%token <string> ID HASHID SSTRING DSTRING URI PERIOD COLON LBRACKET RBRACKET ASSIGN INCLUDES DASHMATCH
%token <string> LPAREN RPAREN PERCENT 
%token <string> EM EX PX CM MM IN PT PC HEXCOLOR
/* %token <string> DIMENSION FREQ LENGTH ANGLE TIME FONTEM FONTEX */
%token EOF

%nonassoc NOELSE
%nonassoc ELSE

%left ASSIGN
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE

%start program
%type <Ast.program> program

%%

program:
    /* empty */ { [], [], [] }
    | program vdecl {
        let (v, r, d) = $1 in
        ($2 :: v, r, d) }
    | program ruleset_decl { 
        let (v, r, d) = $1 in
        (v, $2 :: r, d) }
    | program defdecl {
        let (v, r, d) = $1 in
        (v, r, $2 :: d) }

defdecl:
    ATRULE ID LPAREN formals_opt RPAREN LBRACE vdecl_list stmt_list RBRACE {{
        fname = $2;
        formals = $4;
        dlocals = $7;
        body = List.rev $8; }}

vdecl:
    | DOLLAR ID ASSIGN expr SEMI 
        {  { vdecl_key = $2; vdecl_val = $4; }}

vdecl_list:
    /* nothing */    { [] }
  | vdecl_list vdecl { $2 :: $1 }


stmt_list:
  /* empty */  { [] }
  | stmt_list stmt SEMI { $2 :: $1 }

stmt:
    prop_decl { let (s, expr) = $1 in PropDecl(s, expr) }
    | ATRULE ID LPAREN actuals_opt RPAREN { IncludeDef($2, $4) }

actuals_opt:
    /* empty */ { [] }
    | actuals_list  { List.rev $1 }

actuals_list:
    expr                    { [$1] }
  | actuals_list COMMA expr { $3 :: $1 }

formals_opt:
  /* empty */ { [] }
  | formal_list   { List.rev $1 }

formal_list:
  DOLLAR ID                   { [ $2 ] }
  | formal_list COMMA DOLLAR ID { $4 :: $1 }
   

expr:
    literal { Literal($1) }
    | DOLLAR ID { Id($2) }
    | expr PLUS   expr { Binop($1, Add,   $3) }
    | expr MINUS  expr { Binop($1, Sub,   $3) }
    | expr TIMES  expr { Binop($1, Mult,  $3) }
    | expr DIVIDE expr { Binop($1, Div,   $3) }
    /*
    | DOLLAR ID ASSIGN expr   { Assign($2, $4) }
    | expr EQ     expr { Binop($1, Equal, $3) }
    | expr NEQ    expr { Binop($1, Neq,   $3) }
    | expr LT     expr { Binop($1, Less,  $3) }
    | expr LEQ    expr { Binop($1, Leq,   $3) }
    | expr GT     expr { Binop($1, Greater,  $3) }
    | expr GEQ    expr { Binop($1, Geq,   $3) }
    */
    | LPAREN expr RPAREN { $2 }

literal:
    | ID {{
        bv_fval = 0.0;
        bv_sval = $1;
        bv_type = TYPE_NOQUOTE_STR;
        bv_unit = Nounit; }}

    | NUMBER type_unit {{
        bv_fval = (float_of_string $1);
        bv_sval = "";
        bv_type = TYPE_NUM;
        bv_unit = $2; }}
    | NUMBER {{
        bv_fval = (float_of_string $1);
        bv_sval = "";
        bv_type = TYPE_NUM;
        bv_unit = Nounit; }}
    | SSTRING {{
        bv_sval = $1;
        bv_fval = 0.0;
        bv_type = TYPE_SQUOTE_STR;
        bv_unit = Nounit; }}
    | DSTRING {{
        bv_sval = $1;
        bv_fval = 0.0;
        bv_type = TYPE_DQUOTE_STR;
        bv_unit = Nounit; }}
    | HEXCOLOR {{
        bv_sval = $1;
        bv_fval = 0.0;
        bv_type = TYPE_NOQUOTE_STR;
        bv_unit = Nounit; }}

type_unit:
    | PERCENT { Rellen($1) }
    | EM { Rellen($1) }
    | EX { Rellen($1) }
    | PX { Rellen($1) }
    | CM { Abslen($1) }
    | MM { Abslen($1) }
    | IN { Abslen($1) }
    | PT { Abslen($1) }
    | PC { Abslen($1) }

/*
str_unit:
    | PERCENT { $1 }
    | EM { $1 }
    | EX { $1 }
    | PX { $1 }
    | CM { $1 }
    | MM { $1 }
    | IN { $1 }
    | PT { $1 }
    | PC { $1 }
*/

ruleset_decl:
    selector_list LBRACE vdecl_list stmt_list RBRACE {{
        selector = (List.fold_left list2str3 "" (List.rev $1));
        declaration = (List.rev $4);
        rlocals = $3; }}

prop_decl:
    | prop COLON expr { ($1, $3) }

prop:
    | ID { $1 }

/*
prop_decl_list:
    prop_decl { [ $1 ] }
    | prop_decl_list SEMI prop_decl { $3 :: $1 }

value_list:
    | value { [ $1 ] }
    | value_list space value { $3 :: $1 }
*/

value:
    | DOLLAR ID {{
        bv_sval = $2;
        bv_fval = 0.0;
        bv_type = TYPE_VAR;
        bv_unit = Nounit; }} 
    | URI {{
        bv_sval = $1;
        bv_fval = 0.0;
        bv_type = TYPE_NOQUOTE_STR;
        bv_unit = Nounit; }} 
    | NUMBER type_unit {{
        bv_sval = "";
        bv_fval = (float_of_string $1);
        bv_type = TYPE_NUM;
        bv_unit = $2; }} 
    | NUMBER {{
        bv_sval = "";
        bv_fval = (float_of_string $1);
        bv_type = TYPE_NUM;
        bv_unit = Nounit; }} 
    | SSTRING {{
        bv_sval = $1;
        bv_fval = 0.0;
        bv_type = TYPE_SQUOTE_STR;
        bv_unit = Nounit; }} 
    | DSTRING {{
        bv_sval = $1;
        bv_fval = 0.0;
        bv_type = TYPE_DQUOTE_STR;
        bv_unit = Nounit; }} 
    | ID {{ 
        bv_sval = $1;
        bv_fval = 0.0;
        bv_type = TYPE_NOQUOTE_STR;
        bv_unit = Nounit; }} 
    | HEXCOLOR {{
        bv_sval = $1;
        bv_fval = 0.0;
        bv_type = TYPE_NOQUOTE_STR;
        bv_unit = Nounit; }} 
    
/*
unary_operator:
    MINUS { $1 }
    | PLUS { $1 }
*/

selector_list:
    | simple_selector { [ $1 ] }
    | selector_list COMMA simple_selector { $3 :: $1 }

simple_selector:
    element_name                      { $1 }
    | element_name attrib_selector_list { $1 ^ (List.fold_left list2str "" (List.rev $2)) }
    | attrib_selector_list              { List.fold_left list2str2 "" (List.rev $1) }

element_name:
    ID { $1 }

attrib_selector_list:
    attrib_selector                       { [ $1 ] }
    | attrib_selector_list attrib_selector  { $2 :: $1 }

attrib_selector:
    HASHID { $1 }
    | PERIOD ID { $1 ^ $2 }
    | attrib { $1 }
    | pseudo { $1 }

pseudo:
    | COLON ID { $1 ^ $2 }

attrib:
    LBRACKET ID attrib_match_op attrib_match_val RBRACKET     { $1 ^ $2 ^ $3 ^ $4 ^ $5 }
    | LBRACKET ID RBRACKET                                      { $1 ^ $2 ^ $3 }
    
attrib_match_op:
    ASSIGN    { $1 }
    | INCLUDES  { $1 }
    | DASHMATCH { $1 }

attrib_match_val:
    ID          { $1 }
    | SSTRING    { $1 }
    | DSTRING    { $1 }
