(* 
csslang.ml
----------
This is the main program of csslang.  
It reads input from standard input and combines scanner, parser, and interpreter.
*) 

open Ast
open Printf
open Printexc

let _ = 
    let lexbuf = Lexing.from_channel stdin in
    try
        let program = Parser.program Scanner.csslang_token lexbuf in
            Interpret.run program;
            ();
            (*
            List.map (fun a -> printf "key=%s\n" a.vdecl_key) vars;
            let listing = string_of_program program in
            (printf "%s" listing);
            *)
    with 
        | exn
            -> 
               let curr = lexbuf.Lexing.lex_curr_p in 
               let cnum = curr.Lexing.pos_cnum - curr.Lexing.pos_bol in
               let tok = Lexing.lexeme lexbuf in
               printf "%s: " (Printexc.to_string exn);
               printf "line=%d cnum=%d " curr.Lexing.pos_lnum cnum;
               printf "token=[%s]\n" tok;
               ();
