(* 
ast.mli
-------
This file defines the data structures for consturcting an abstract syntax tree
*)

type op = Add | Sub | Mult | Div

type var_type = VARNUM of float | VARCOLOR of string | VARSTR of string

type data_type = 
    TYPE_NUM
    | TYPE_SQUOTE_STR (* single quoted str *)
    | TYPE_DQUOTE_STR (* double quoted str *)
    | TYPE_NOQUOTE_STR (* no-quote str*)
    | TYPE_VAR (* var whose bv_sval is the name of another var *)

type unit_type =
    Abslen of string
    | Rellen of string
    | Nounit

type basic_val = {
    bv_sval: string;
    bv_fval: float;
    bv_type: data_type;
    bv_unit: unit_type;
}

type expr =
    Literal of basic_val
  | Id of string
  | Binop of expr * op * expr
  | Assign of string * expr

type var_decl = {
    vdecl_key: string;
    vdecl_val: expr;
}

type stmt =  
    PropDecl of string * expr 
    | IncludeDef of string * expr list
    | VarDecl of var_decl


type ruleset = {
    selector: string;
    declaration: stmt list;
    rlocals: var_decl list;
}

type ruledef_decl = {
    fname: string;
    formals: string list;
    dlocals: var_decl list;
    body: stmt list;
}

type program = var_decl list * ruleset list * ruledef_decl list
