{
  open Parser
  exception Eof
}

let digit = ['0'-'9']

rule token = parse
  [' ' '\t' '\r' '\n'] { token lexbuf }    	(* Whitespace *)
| "/*"     	{ comment lexbuf }           	(* Comments *)
| '('      	{ LPAREN }
| ')'      	{ RPAREN }
| '['	   	{ LBRACKET }
| ']'      	{ RBRACKET }
| '{'      	{ LBRACE }
| '}'      	{ RBRACE }
| ';'      	{ SEMI }
| ','      	{ COMMA }
| ':'      	{ COLON }
| '+'      	{ PLUS }
| '-'      	{ MINUS }
| '*'      	{ TIMES }
| '/'      	{ DIVIDE }
| '^'      	{ CARET }
| "<<"	   	{ LSHIFT }
| ">>"	   	{ RSHIFT }
| '='      	{ ASSIGN }
| "=="     	{ EQ }
| "!="     	{ NEQ }
| '<'      	{ LT }
| "<="     	{ LEQ }
| '>'      	{ GT }
| ">="     	{ GEQ }
| "&&"     	{ AND }
| "||"     	{ OR }
| '!'     	{ NOT }
| "if"     	{ IF }
| "else"   	{ ELSE }
| "for"    	{ FOR }
| "while"  	{ WHILE }
| "return" 	{ RETURN } 
| "true"   	{ TRUE }
| "false"  	{ FALSE }
| "int"    	{ INT }
| "float"  	{ FLOAT }
| "string" 	{ STRING }
| "boolean"	{ BOOLEAN }
| "poly"   	{ POLY }
| digit+ as lxm { INTLITERAL(int_of_string lxm) } 
| digit+ ('.' digit+)+ as lxm { FLOATLITERAL(float_of_string lxm) }
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
| '"' ([^ '"' '\n' '\r' '\\'] | "\\\\" | "\\\"" | "\\n" | "\\t")* '"' as lxm { STRINGLITERAL(lxm) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  "*/" { token lexbuf }
| _    { comment lexbuf }

