type action = Ast | Compile | Javacode | Typecheck | All


let _ =
  let action = if Array.length Sys.argv > 1 then
      List.assoc Sys.argv.(1) [ ("-a", Ast);
                                ("-j", Javacode);
                                ("-t", Typecheck);
                                ("-c", All)]
  else Compile in
  let input_file = ref Sys.argv.(2) in
  let input = open_in !input_file in
  let lexbuf = Lexing.from_channel input in
  let program = Parser.program Scanner.token lexbuf in
  match action with
    Ast -> let listing = Ast.string_of_program program
           in print_string listing
  | Typecheck -> Typecheck.typecheck_program program
  | Javacode ->
    let listing =
      Javacode.jstring_of_program program !input_file
    in print_endline listing
  | All ->
     ignore (Typecheck.typecheck_program program);
     let listing =
           Javacode.jstring_of_program program !input_file
     in print_endline listing
     