#include <stdio.h>
#include <math.h>
#include "dft.h"

#define N 1000

/* This program demonstrates the complex arithmetic and array
features of COAL.  A signal is generated (once in C and once in COAL)
and its 2nd harmonic distortion calculated. */
int main()
{
    double signal[N];
    double f1;
    double f2;
    double w1;
    double w2;
    int i;
    coal_arr s1;
    coal_arr s2;
    coal_num res;
    
    /* create signal with 2nd harmonic distortion */
    f1 = 100.0;
    f2 = 200.0;
    for(i=0; i<N; ++i)
    {
        signal[i] = sin(2.0*M_PI*f1*i/N) + .2 * cos(2.0*M_PI*f2*i/N);
    }

    /* setup coal array to send as argument to COAL function */
    s1 = cl_real_arr(signal, N);
    
    /* do analysis */
    res = distortion(s1, cl_num(f1,0.0), cl_num(f2,0.0));
    if (!cl_valid_num(res))
    {
        printf("Error %d at distortion.\n", cl_last_err());
        return -1;
    }
    
    /* report */
    printf("2nd harmonic distortion is %f.\n", cl_dbl_re(res));
    
    
    /* create signal with 2nd harmonic distortion in COAL */
    s2 = make_two_tone(cl_num(N,0.0)
                     , cl_num(f1,0.0)
                     , cl_num(1.0,0.0)
                     , cl_num(f2,0.0)
                     , cl_num(.2,0.0) 
                     );
    if (!cl_valid_arr(s2))
    {
        printf("Error %d at make_two_tone.\n", cl_last_err());
        return -1;
    }
    
    /* do analysis */
    res = distortion(s2, cl_num(f1,0.0), cl_num(f2,0.0));
    if (!cl_valid_num(res))
    {
        printf("Error %d at distortion.\n", cl_last_err());
        return -1;
    }
    
    /* report */
    printf("2nd harmonic distortion is %f.\n", cl_dbl_re(res));

    return 0;
}
