(* COMS W4115, COAL, Eliot Scull, CUID: C000056091 *)

type typ =
  Num
| NumArr
| Func of typ * typ list
| Tbd
| Var of typ ref

let fresh () = Var(ref Tbd);;

(* strip off any Var's *)
let rec baretyp t =
  match t with
    Var({contents = inner}) -> baretyp inner
  | _ -> t
;;
   
let rec string_of_type = function
    Num -> "Num"
  | NumArr -> "NumArr"
  | Func(rt, ats) -> "Func(" ^ string_of_type rt ^ ", " ^ String.concat ", " (List.map string_of_type ats) ^ ")"
  | Tbd -> "?"
  | Var({contents = inner}) -> "Var(" ^ (string_of_type inner) ^ ")"
;;

(* strip off any Var's *)
let rec string_of_type_clean = function
    Num -> "Num"
  | NumArr -> "NumArr"
  | Func(rt, ats) -> "Func(" ^ string_of_type rt ^ ", " ^ String.concat ", " (List.map string_of_type ats) ^ ")"
  | Tbd -> "?"
  | Var({contents = inner}) -> string_of_type_clean inner
;;
