(* COMS W4115, COAL, Eliot Scull, CUID: C000056091 *)

open Types

(* type checking exceptions *)
exception Symbol_not_found of string
exception Symbol_redefinition of string * typ
exception Type_mismatch of typ * typ

(* symbol table *)
type symbol_table = {
   parent: symbol_table option;
   context: string;
   mutable scope: symbol list
}
and symbol = { 
    sname: string;
    st: typ
}

(* add symbol to current environment *)
let addsym env n t =
    if (not (List.exists (fun sy -> sy.sname=n) env.scope)) 
        then (env.scope <- {sname=n; st=t} :: env.scope; t)
        else raise (Symbol_redefinition(n, t));;

let rec find_env_typ env n = 
    try
        (* look in current scope *)
        env, (List.find (fun sy -> sy.sname=n) env.scope).st
    with Not_found -> match env.parent with
                        (* in top scope - symbol not found *)
                        None -> raise (Symbol_not_found(n))
                        (* search parent scope *)
                      | Some(parent_env) -> find_env_typ parent_env n;;

(* find a type for a given symbol - search current and then parent environments *)
let rec findtyp env n = snd (find_env_typ env n)

(* find a environment for a given symbol - search current and then parent environments *)
let rec findenv env n = fst (find_env_typ env n)

let symbol_names env = List.map (fun symbol -> symbol.sname) env.scope
                      
let dump env =
    List.iter (fun symbol -> Printf.printf "{sname=%s, st=%s}\n" symbol.sname (string_of_type symbol.st)) env.scope;;

(* create a new subordinate scope - keep reference to parent scope *)
let newscope c env = 
    {parent=Some(env); context=c; scope=[]};;
