(* COMS W4115, COAL, Eliot Scull, CUID: C000056091 *)

{ open Parser 
  open Lexing }

let digit = ['0'-'9']
let sign = ('+'|'-')*
let expon = 'e' sign digit+
let integer = digit+
let float = digit+ expon 
          | digit+ '.' digit* expon?
		  | digit* '.' digit+ expon?
let whitespace = [' ' '\t' '\r' '\n']

rule token = parse
   
whitespace { token lexbuf }
   
| '+' { PLUS }
| '-' { MINUS }
| '*' { TIMES }
| '/' { DIVIDE }
| '^' { EXPON }

| '>'   { GT }
| '<'   { LT }
| ">="  { GTE }
| "<="  { LTE }
| '='   { EQL }
| "<>"  { NEQL }

| ','   { COMMA }
| ';'   { SEMI }
| "<-"  { LARR }
| "->"  { RARR }


| '('   { LPAREN }
| ')'   { RPAREN }

| '{'   { LCURLY }
| '}'   { RCURLY }

| '['   { LSQUARE }
| ']'   { RSQUARE }

| '\\'   { BACKSLASH }

| "if"      { IF }
| "then"    { THEN }
| "else"    { ELSE }

| integer as lit { INT(lit) }
| float as lit { REAL(lit) }
| (integer|float) 'i' as lit { IMAG(lit) }

| ".." { RANGE }

(* Special case to disambiguate a floating point number
   and an integer right before the range operator.  In
   latter case, extract integer lexeme and back up two
   characters so that range operator is scanned as usual. *)
| integer as lit ".." {
	lexbuf.lex_curr_pos <- lexbuf.lex_curr_pos - 2; 
	INT(lit) 
	}

(* Constants *)
| "PI" { REAL("3.1415927") }
| "PIi" { IMAG("3.1415927") }
| "2PI" { REAL("6.2831853") }
| "2PIi" { IMAG("6.2831853") }

(* ID's *)
| ['a'-'z' 'A'-'Z'] ['a'-'z' 'A'-'Z' '0'-'9' '_']* as name { ID(name) }

(* Comments *)
| '#'[^ '\n' '\r']* { token lexbuf }

| eof { EOF }
