(* COMS W4115, COAL, Eliot Scull, CUID: C000056091 *)

type expr =

  (* returns Num *)
    Real of string * bool
  | Imag of string
  | Id of string
  | Negate of typed_expr
  | Binop of typed_expr * Ast.op * typed_expr
  | Assign of string * typed_expr
  | GetElem of typed_expr * typed_expr
  | PutElem of typed_expr * typed_expr * typed_expr

  (* returns NumArr *)
  | Map of callee * typed_expr
  | Range of typed_expr * typed_expr * typed_expr

  (* returns Num or NumArr *)
  | Invoke of callee * typed_expr list
  | Reduce of callee * typed_expr * typed_expr
  | IfThenElse of typed_expr * typed_expr * typed_expr
  | Sequence of typed_expr * typed_expr
  
and
typed_expr = expr * Types.typ

and callee =
  Named of string 
| Lambda of func_def

and func_def = 
{
    fname : string;
    fargs : string list;
    fbody : typed_expr;
    flocals : Sym.symbol_table
}

type program = func_def list

