(* COMS W4115, COAL, Eliot Scull, CUID: C000056091 *)

open Types
open Sast
open Sym

let string_of_op = function
    Ast.Add -> "+"
  | Ast.Sub -> "-"
  | Ast.Mul -> "*"
  | Ast.Div -> "/"
  | Ast.Pow -> "^"
  | Ast.Eq  -> "="
  | Ast.Neq -> "<>"
  | Ast.Lt  -> "<"
  | Ast.Lte -> "<="
  | Ast.Gt  -> ">"
  | Ast.Gte -> ">="
  
let rec string_of_expr = function
    Real(fps, _) -> fps
    
  | Imag(fps) -> fps ^ "i"
  
  | Id(name) -> name
  
  | Negate(se) -> 
      "-" ^ (string_of_expr (fst se))
      
  | Binop(se1, op, se2) ->
      (string_of_expr (fst se1)) 
      ^ " " 
      ^ (string_of_op op) ^ " "
      ^ (string_of_expr (fst se2)) 
      
  | Assign(name, se) ->
      (string_of_type_clean (snd se)) 
      ^ " " 
      ^ name 
      ^ " <- " 
      ^ string_of_expr (fst se)
      
  | GetElem(se1, se2) ->
      (string_of_expr (fst se1)) 
      ^ "[" 
      ^ (string_of_expr (fst se2)) 
      ^ "]"
      
  | PutElem(se1, se2, se3) ->
      (string_of_expr (fst se1)) 
      ^ "[" 
      ^ (string_of_expr (fst se2)) 
      ^ "]<-"
      ^ (string_of_expr (fst se3))
      
  | Map(callee, se) ->
      (string_of_callee callee) 
      ^ "{" 
      ^ string_of_expr (fst se) 
      ^ "}"
      
  | Range(se1, se2, se3) ->
      string_of_expr (fst se1) 
      ^ ".." ^ string_of_expr (fst se2)
      ^ "\\" ^ string_of_expr (fst se3)
      
  | Invoke(callee, selist) -> 
      (string_of_callee callee) ^ "(" 
      ^ String.concat ", " (List.map (fun se-> string_of_expr (fst se)) selist) 
      ^ ")"
        
  | Reduce(callee, se1, se2) -> 
      (string_of_callee callee) 
      ^ "{" 
      ^ string_of_expr (fst se1) 
      ^ ", " 
      ^ string_of_expr (fst se2) 
      ^ "}"
      
  | IfThenElse(se1, se2, se3) ->
      "if " ^ string_of_expr (fst se1)
      ^ " then " ^ string_of_expr (fst se2)
      ^ " else " ^ string_of_expr (fst se3)
      
  | Sequence(se1, se2) ->
      (string_of_expr (fst se1)) 
      ^ ";\n" 
      ^ (string_of_expr (fst se2))
      
and string_of_callee = function
    Named(fname) -> fname
  | Lambda(fdef) -> 
    let args = 
       String.concat ", " 
         (List.map 
               (fun name -> (string_of_type_clean (findtyp fdef.flocals name)) ^ " " ^ name)
               fdef.fargs
               ) in
    "(" ^ args ^ " -> " ^ string_of_expr (fst fdef.fbody) ^ ")";;

let string_of_fdef fdef =
    let args = 
       String.concat ", " 
         (List.map
               (fun name -> (string_of_type_clean (findtyp fdef.flocals name)) ^ " " ^ name)
               fdef.fargs
               ) in
    (string_of_type_clean (snd fdef.fbody)) ^ " " ^ fdef.fname ^ "(" ^ args ^ ") -> \n"
    ^ string_of_expr (fst fdef.fbody)
;;

(* convert SAST to a string *)
let string_of_program fdefs = 
    String.concat "\n\n" (List.map string_of_fdef fdefs)
