/* COMS W4115, COAL, Eliot Scull, CUID: C000056091 */

%{
open Ast 

(* enumerate lambda functions internally in order of occurence *)
let lambda_num = ref 0;;
let next_lambda_num () = (lambda_num:=!lambda_num + 1); !lambda_num;;

%}

%token LPAREN RPAREN LCURLY RCURLY LSQUARE RSQUARE COMMA SEMI BACKSLASH
%token PLUS MINUS TIMES DIVIDE EXPON
%token EQL NEQL LT LTE GT GTE
%token LARR RARR
%token IF THEN ELSE
%token RANGE
%token <string> INT
%token <string> REAL
%token <string> IMAG
%token <string> ID
%token COMMENT EOF

%left COMMA SEMI
%right LARR
%nonassoc ELSE
%nonassoc RANGE 
%nonassoc BACKSLASH
%nonassoc RARR
%left EQL NEQL
%left LT LTE GT GTE
%left PLUS MINUS
%left TIMES DIVIDE
%left EXPON
%right negate_op
%nonassoc LCURLY RCURLY LSQUARE RSQUARE

%start program
%type <Ast.program> program

%%

program:
   /* nothing */   { [] }
| program func_def { $2 :: $1 }

expr:

/* Returns Number */
  ID    { Id  ($1) }
| INT   { Real($1, true) }
| REAL  { Real($1, false) }
| IMAG  { Imag(String.sub $1 0 ((String.length $1)-1)) }
| MINUS expr %prec negate_op { Negate($2) }
| expr PLUS   expr { Binop($1, Add, $3) }
| expr MINUS  expr { Binop($1, Sub, $3) }
| expr TIMES  expr { Binop($1, Mul, $3) }
| expr DIVIDE expr { Binop($1, Div, $3) }
| expr LT     expr { Binop($1, Lt , $3) }
| expr LTE    expr { Binop($1, Lte, $3) }
| expr GT     expr { Binop($1, Gt , $3) }
| expr GTE    expr { Binop($1, Gte, $3) }
| expr EQL    expr { Binop($1, Eq , $3) }
| expr NEQL   expr { Binop($1, Neq, $3) }
| expr EXPON  expr { Binop($1, Pow, $3) }
| expr LSQUARE expr RSQUARE { GetElem($1, $3) }
| expr LSQUARE expr RSQUARE LARR expr { PutElem($1, $3, $6) }
| ID LARR expr { Assign($1, $3) }

/* Returns array of Number */
| ID LCURLY expr RCURLY     { Map(Named($1), $3) } 
| lambda LCURLY expr RCURLY { Map(Lambda($1), $3) }
| ID LCURLY expr COMMA expr RCURLY     { Reduce(Named($1), $3, $5) }
| lambda LCURLY expr COMMA expr RCURLY { Reduce(Lambda($1), $3, $5) }
| expr RANGE expr                { Range($1, $3, Real("1",true)) }
| expr RANGE expr BACKSLASH expr { Range($1, $3, $5) }

/* Returns Number or array of Number */
| LPAREN expr RPAREN { $2 }
| ID LPAREN invoke_arg_opt RPAREN    { Invoke(Named($1), List.rev $3) }
| lambda LPAREN invoke_arg_list RPAREN { Invoke(Lambda($1), List.rev $3) }
| expr SEMI expr { Sequence($1, $3) }
| IF expr THEN expr ELSE expr { IfThenElse($2, $4, $6) } 
  
invoke_arg_opt:
  /* nothing */    { [] }
| invoke_arg_list  { $1 }

invoke_arg_list:
  expr { [$1] }
| invoke_arg_list COMMA expr { $3 :: $1 }

func_arg_opt:
  /* nothing */  { [] }
| func_arg_list  { $1 }
 
func_arg_list:
  ID { [$1] }
| func_arg_list COMMA ID { $3 :: $1 }

lambda:
  LPAREN func_arg_list RARR expr RPAREN { { fname = "_lambda" ^ (string_of_int (next_lambda_num ()));
                                            fargs = List.rev $2;
                                            fbody = $4; } }

func_def:
  ID LPAREN func_arg_opt RPAREN RARR expr { { fname = $1;
                                              fargs = List.rev $3;
                                              fbody = $6; } }
