(* COMS W4115, COAL, Eliot Scull, CUID: C000056091 *)

type op = Add | Sub | Mul | Div | Pow | Eq | Neq | Lt | Lte | Gt | Gte

type expr =

  (* returns Num *)
    Real of string * bool
  | Imag of string
  | Id of string
  | Negate of expr
  | Binop of expr * op * expr
  | Assign of string * expr
  | GetElem of expr * expr
  | PutElem of expr * expr * expr

  (* returns NumArr *)
  | Map of callee * expr
  | Range of expr * expr * expr

  (* returns Num or NumArr *)
  | Invoke of callee * expr list
  | Reduce of callee * expr * expr
  | IfThenElse of expr * expr * expr
  | Sequence of expr * expr
  
and callee =
  Named of string 
| Lambda of func_def

and func_def = {
    fname : string;
    fargs : string list;
    fbody : expr;
  }

type program = func_def list
