#!/bin/bash

ROOT=`dirname $0`
BOGUSCMD="${ROOT}/bogus"
TESTDIR="${ROOT}/test"
WIDTH=12

SINGLE_TEST_MODE=0

FAILURES=0

if [ -z $1 ]; then
    TESTS=`find ${TESTDIR} -name '*.bog' -printf '%f\n' | sed 's/.bog$//' | sort`
else
    TESTS="$@"
    SINGLE_TEST_MODE=1
fi

run_test()
{
    local t=$1

    /usr/bin/printf "%-${WIDTH}s%s" ${t}

    if [ ! -e "$TESTDIR/$t.bog" ]; then
        echo "                NOT FOUND"
        FAILURES=`expr $FAILURES + 1`
        return
    fi

    if [ ! -e "$TESTDIR/$t.out" ]; then
        echo "                OUTPUT FILE NOT FOUND"
        FAILURES=`expr $FAILURES + 1`
        return
    fi

    OUTPUT=`$BOGUSCMD "$TESTDIR/$t.bog" 2>&1 | diff - "$TESTDIR/$t.out" 2>&1`
    if [ $? == 0 ]; then
        echo "PASSED"
    else
        echo "        FAILED"
        FAILURES=`expr $FAILURES + 1`
    fi

    if [[ $SINGLE_TEST_MODE != 0 ]]; then
        echo
        echo "Output of test $t:"
        $BOGUSCMD "$TESTDIR/$t.bog"
    fi



}

for t in $TESTS
do
    run_test $t
done

echo 

if [ $FAILURES == 0 ]; then
    echo "All tests SUCCEED"
else
    echo "$FAILURES tests FAILED"
fi
