%{ open Ast %}

%token SEMI LPAREN RPAREN LBRACE RBRACE COMMA
%token PLUS MINUS TIMES DIVIDE ASSIGN
%token AND OR NOT
%token EQ NEQ LT LEQ GT GEQ
%token PRINT READ
%token TO_STRING TO_INT TO_FLOAT
%token IF ELSE FOR WHILE INT DRAW END EXIT FALSE HAS LOCAL TRUE RULE NONE
%token BOOL INT FLOAT STRING
%token <int> INTLIT
%token <string> STRINGLIT
%token <float> FLOATLIT
%token <string> ID
%token EOF

%nonassoc NOELSE
%nonassoc ELSE

%left ASSIGN
%left AND OR
%left NOT
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE
%left NEG

%start program
%type <Ast.program> program

%%

program:
    all_comp_decls global_decls rule_decls { $1, $2, $3 }

all_comp_decls:
    comp_decl1 comp_decl1 comp_decl1 { [ $1 ; $2 ; $3 ] }

comp_decl1:
    ID HAS comp_member_list_opt SEMI
        { { cname = $1;
            cmembers = $3 } }
            
comp_member_list_opt:
    NONE { [] }
  | comp_member_list { List.rev $1 }

comp_member_list:
    comp_member     { [$1] }
  | comp_member_list COMMA comp_member { $3 :: $1 }

comp_member:
    ID LPAREN prim_type RPAREN { { mname = $1; mtype = $3 } }

prim_type:
    BOOL    { Bool }
  | INT     { Int }
  | FLOAT   { Float }
  | STRING  { String }

global_decls:
    { [] }
  | assign_list     { List.rev $1 }

assign_list:
    assignment             { [$1] }
  | assign_list assignment { $2 :: $1 }

assignment:
    ID ASSIGN expr SEMI   { Expr(Assign ($1, $3, false)) }

rule_decls:
    { [] }
  | rule_decls rule_decl { $2 :: $1 }
    
rule_decl:
   RULE ID LBRACE stmt_list RBRACE
     { { rname = $2;
         body = List.rev $4 }}

stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

stmt:
    expr SEMI { Expr($1) }
  | LBRACE stmt_list RBRACE { Block(List.rev $2) }
  | IF LPAREN expr RPAREN stmt %prec NOELSE { If($3, $5, Block([])) }
  | IF LPAREN expr RPAREN stmt ELSE stmt    { If($3, $5, $7) }
  | WHILE LPAREN expr RPAREN stmt { While($3, $5) }
  | PRINT expr SEMI      { Print($2) }
  | END SEMI { End }
  | EXIT SEMI { Exit }

expr:
    INTLIT           { IntLit($1) }
  | TRUE             { BoolLit(true) }
  | FALSE            { BoolLit(false) }
  | STRINGLIT        { StringLit($1) }
  | FLOATLIT         { FloatLit ($1) }
  | ID               { Id($1) }
  | READ             { Read }
  | TO_STRING LPAREN expr RPAREN   { ToString($3) }
  | TO_INT LPAREN    expr RPAREN   { ToInt($3) }
  | TO_FLOAT LPAREN  expr RPAREN   { ToFloat($3) }
  | expr PLUS   expr { Binop($1, Add,   $3) }
  | expr MINUS  expr { Binop($1, Sub,   $3) }
  | expr TIMES  expr { Binop($1, Mult,  $3) }
  | expr DIVIDE expr { Binop($1, Div,   $3) }
  | expr EQ     expr { Binop($1, Equal, $3) }
  | expr NEQ    expr { Binop($1, Neq,   $3) }
  | expr LT     expr { Binop($1, Less,  $3) }
  | expr LEQ    expr { Binop($1, Leq,   $3) }
  | expr GT     expr { Binop($1, Greater,  $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3) }
  | expr AND    expr { LazyBinop($1, And,   $3) }
  | expr OR     expr { LazyBinop($1, Or,   $3) }
  | NOT expr         { Not ($2) }
  | MINUS expr %prec NEG { Negate ($2) }
  | ID ASSIGN expr   { Assign($1, $3, false) }
  | LOCAL ID ASSIGN expr { Assign($2, $4, true) }
  | LPAREN expr RPAREN { $2 }

