type op = Add | Sub | Mult | Div |  Equal | Neq | Less | Leq | Greater | Geq 

type lazyop = And | Or

type expr =
    IntLit of int
  | BoolLit of bool
  | StringLit of string
  | FloatLit of float
  | Id of string
  | Binop of expr * op * expr
  | LazyBinop of expr * lazyop * expr
  | Assign of string * expr * bool
  | Call of string * expr list
  | Draw
  | Read
  | Noexpr
  | Negate of expr
  | ToString of expr
  | ToInt of expr
  | ToFloat of expr
  | Not of expr

type stmt =
    Block of stmt list
  | Expr of expr
  | If of expr * stmt * stmt
  | While of expr * stmt
  | Print of expr
  | End
  | Exit

type t = 
    Bool
  | Int
  | Float
  | String

type rule_decl = {
    rname : string;
    (* locals : string list; *)
    body : stmt list
}

type comp_decl_member = {
    mname : string ;
    mtype : t
}

type comp_decl = {
    cname : string ;
    cmembers : comp_decl_member list
}

type program = comp_decl list * stmt list * rule_decl list
